/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.model;

import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.sonar.Messages;
import hudson.triggers.SCMTrigger;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.kohsuke.stapler.DataBoundConstructor;

public class TriggersConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean skipScmCause;
    private boolean skipUpstreamCause;
    private String envVar;

    public TriggersConfig() {
        this.skipScmCause = false;
        this.skipUpstreamCause = false;
        this.envVar = null;
    }

    @DataBoundConstructor
    public TriggersConfig(boolean skipScmCause, boolean skipUpstreamCause, @CheckForNull String envVar) {
        this.skipScmCause = skipScmCause;
        this.skipUpstreamCause = skipUpstreamCause;
        this.envVar = envVar;
    }

    public boolean isSkipScmCause() {
        return this.skipScmCause;
    }

    public void setSkipScmCause(boolean b) {
        this.skipScmCause = b;
    }

    public boolean isSkipUpstreamCause() {
        return this.skipUpstreamCause;
    }

    public void setSkipUpstreamCause(boolean b) {
        this.skipUpstreamCause = b;
    }

    public String getEnvVar() {
        return Util.fixEmptyAndTrim((String)this.envVar);
    }

    public void setEnvVar(String envVar) {
        this.envVar = envVar;
    }

    public String isSkipSonar(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        Result result = build.getResult();
        if (result != null && result.isWorseThan(Result.UNSTABLE)) {
            return Messages.SonarPublisher_BadBuildStatus(result.toString());
        }
        if (this.getEnvVar() != null) {
            String value = (String)build.getBuildVariableResolver().resolve(this.getEnvVar());
            if ("true".equalsIgnoreCase(value)) {
                return Messages.Skipping_Sonar_analysis();
            }
            EnvVars envVars = build.getEnvironment((TaskListener)listener);
            value = (String)new VariableResolver.ByMap((Map)envVars).resolve(this.getEnvVar());
            if ("true".equalsIgnoreCase(value)) {
                return Messages.Skipping_Sonar_analysis();
            }
        }
        ArrayList causes = new ArrayList(build.getCauses());
        if (this.isSkipScmCause() || this.isSkipUpstreamCause()) {
            Iterator iter = causes.iterator();
            while (iter.hasNext()) {
                Cause cause = (Cause)iter.next();
                if ((!this.isSkipScmCause() || !SCMTrigger.SCMTriggerCause.class.isInstance(cause)) && (!this.isSkipUpstreamCause() || !Cause.UpstreamCause.class.isInstance(cause))) continue;
                iter.remove();
            }
        }
        return causes.isEmpty() ? Messages.Skipping_Sonar_analysis() : null;
    }

    public static class SonarCause
    extends Cause {
        public String getShortDescription() {
            return null;
        }
    }
}

