/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.sonar.SonarRunnerInstaller;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class SonarRunnerInstallation
extends ToolInstallation
implements EnvironmentSpecific<SonarRunnerInstallation>,
NodeSpecific<SonarRunnerInstallation> {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public SonarRunnerInstallation(String name, @CheckForNull String home, List<? extends ToolProperty<?>> properties) {
        super(Util.fixEmptyAndTrim((String)name), Util.fixEmptyAndTrim((String)home), properties);
    }

    public String getExecutable(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new GetExecutable(this.getHome()));
    }

    public SonarRunnerInstallation forEnvironment(EnvVars environment) {
        return new SonarRunnerInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public SonarRunnerInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new SonarRunnerInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    private static class GetExecutable
    extends MasterToSlaveCallable<String, IOException> {
        private final String rawHome;

        GetExecutable(String rawHome) {
            this.rawHome = rawHome;
        }

        public String call() throws IOException {
            File exe = GetExecutable.getExeFile("sonar-scanner", this.rawHome);
            if (exe.exists()) {
                return exe.getPath();
            }
            File oldExe = GetExecutable.getExeFile("sonar-runner", this.rawHome);
            if (oldExe.exists()) {
                return oldExe.getPath();
            }
            return null;
        }

        private static File getExeFile(String name, String rawHome) {
            Object execName = Functions.isWindows() ? name + ".bat" : name;
            String home = Util.replaceMacro((String)rawHome, (Map)EnvVars.masterEnvVars);
            return new File(home, "bin/" + (String)execName);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<SonarRunnerInstallation> {
        private volatile SonarRunnerInstallation[] installations = new SonarRunnerInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "SonarQube Scanner";
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new SonarRunnerInstaller(null));
        }

        public SonarRunnerInstallation[] getInstallations() {
            return this.installations;
        }

        public SonarRunnerInstallation newInstance(StaplerRequest req, JSONObject formData) {
            return (SonarRunnerInstallation)((Object)req.bindJSON(this.clazz, formData));
        }

        public void setInstallations(SonarRunnerInstallation ... antInstallations) {
            this.installations = antInstallations;
            this.save();
        }
    }
}

