/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.ItemGroup;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarPublisher;
import hudson.plugins.sonar.utils.Logger;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=100.0)
public class SonarGlobalConfiguration
extends GlobalConfiguration {
    private final Supplier<Jenkins> jenkinsSupplier;
    private volatile SonarInstallation[] installations = new SonarInstallation[0];
    private volatile boolean buildWrapperEnabled = false;
    boolean dataMigrated = false;
    private boolean credentialsMigrated;

    public SonarGlobalConfiguration() {
        this(() -> Optional.ofNullable(Jenkins.getInstanceOrNull()).orElseThrow(() -> new IllegalStateException("Could not get Jenkins instance")));
    }

    @VisibleForTesting
    public SonarGlobalConfiguration(Supplier<Jenkins> supplier) {
        this.load();
        this.jenkinsSupplier = supplier;
    }

    public SonarInstallation[] getInstallations() {
        return this.installations;
    }

    public boolean isBuildWrapperEnabled() {
        return this.buildWrapperEnabled;
    }

    public void setInstallations(SonarInstallation ... installations) {
        this.installations = installations;
        this.save();
    }

    public void setBuildWrapperEnabled(boolean enabled) {
        this.buildWrapperEnabled = enabled;
        this.save();
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public void migrateData() {
        if (this.dataMigrated) {
            return;
        }
        Optional<SonarPublisher.DescriptorImpl> publisherOpt = ExtensionList.lookup(SonarPublisher.DescriptorImpl.class).stream().findFirst();
        publisherOpt.ifPresent(publisher -> {
            if (publisher.getDeprecatedInstallations() != null && publisher.getDeprecatedInstallations().length > 0) {
                if (ArrayUtils.isEmpty((Object[])this.installations)) {
                    this.installations = publisher.getDeprecatedInstallations();
                    this.buildWrapperEnabled = publisher.isDeprecatedBuildWrapperEnabled();
                    this.save();
                } else {
                    Logger.LOG.warning("SonarQube server configurations exist in both deprecated SonarPublisher and SonarGlobalConfiguration. Deleting deprecated configuration..");
                }
                publisher.deleteGlobalConfiguration();
            }
        });
        this.dataMigrated = true;
        this.save();
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public void migrateCredentials() {
        if (this.credentialsMigrated) {
            return;
        }
        Arrays.stream(this.installations).forEach(SonarInstallation::migrateTokenToCredential);
        this.credentialsMigrated = true;
        this.save();
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        List list = req.bindJSONToList(SonarInstallation.class, json.get("inst"));
        boolean enableBuildWrapper = json.getBoolean("enableBuildWrapper");
        this.setInstallations(list.toArray(new SonarInstallation[list.size()]));
        this.setBuildWrapperEnabled(enableBuildWrapper);
        return true;
    }

    public FormValidation doCheckMandatory(@QueryParameter String value) {
        return StringUtils.isBlank((String)value) ? FormValidation.error((String)Messages.SonarGlobalConfiguration_MandatoryProperty()) : FormValidation.ok();
    }

    public static SonarGlobalConfiguration get() {
        return (SonarGlobalConfiguration)((Object)GlobalConfiguration.all().get(SonarGlobalConfiguration.class));
    }

    public ListBoxModel doFillCredentialsIdItems(@QueryParameter String credentialsId) {
        return this.createListBoxModel(credentialsId);
    }

    public ListBoxModel doFillWebhookSecretIdItems(@QueryParameter String webhookSecretId) {
        return this.createListBoxModel(webhookSecretId);
    }

    private ListBoxModel createListBoxModel(String credentialId) {
        if (!this.jenkinsSupplier.get().hasPermission(Jenkins.ADMINISTER)) {
            return new StandardListBoxModel().includeCurrentValue(credentialId);
        }
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)this.jenkinsSupplier.get(), StringCredentials.class, Collections.emptyList(), CredentialsMatchers.always());
    }
}

