/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.ready.jenkins;

import com.smartbear.ready.jenkins.ParameterContainer;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ProcessRunner {
    public static final String READYAPI_REPORT_DIRECTORY = "ReadyAPI_report";
    public static final String REPORT_FORMAT = "PDF";
    private static final String TESTRUNNER_NAME = "testrunner";
    private static final String LAST_ELEMENT_TO_READ = "con:soapui-project";
    private static final String ATTRIBUTE_TO_CHECK = "updated";
    private static final String TERMINATION_STRING = "Please enter absolute path of the license file";
    private static final String SH = ".sh";
    private static final String BAT = ".bat";
    private static final String REPORT_CREATED_DETERMINANT = "Created report at";
    private static final String SOAPUI_PRO_TESTRUNNER_DETERMINANT = "com.smartbear.ready.cmd.runner.pro.SoapUIProTestCaseRunner";
    private static final String DEFAULT_PLUGIN_VERSION = "1.0";
    private static final String SOAPUI_PRO_FUNCTIONAL_TESTING_PLUGIN_INFO = "/soapUiProFunctionalTestingPluginInfo.properties";
    private static final String TESTRUNNER_VERSION_DETERMINANT = "ready-api-ui-";
    private static final String PROJECT_REPORT = "Project Report";
    private static final String TESTSUITE_REPORT = "TestSuite Report";
    private static final String TESTCASE_REPORT = "TestCase Report";
    private static final String PLUGIN_NAME_FOR_ANALYTICS = "Jenkins";
    private static final char FOLDER_NAME_SEPARATOR = '-';
    private static final int TESTRUNNER_VERSION_FOR_ANALYTICS_FIRST_NUMBER = 2;
    private static final int TESTRUNNER_VERSION_FOR_ANALYTICS_SECOND_NUMBER = 4;
    private String slaveFileSeparator;
    private String PRINTABLE_REPORT_CREATED_DETERMINATION = "Created report [%s]";
    private boolean isReportCreated;
    private boolean isPrintableReportCreated;
    private boolean isSoapUIProProject = false;
    private VirtualChannel channel;
    private String printableReportPath;
    private String printableReportName;
    private String reportsFolderPath;

    ProcessRunner() {
    }

    Proc run(ParameterContainer params, final @Nonnull Run<?, ?> run, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        FilePath testrunnerFile;
        String testrunnerFilePath;
        ArrayList<String> processParameterList;
        PrintStream out;
        block20: {
            out = listener.getLogger();
            processParameterList = new ArrayList<String>();
            this.channel = launcher.getChannel();
            this.setSlaveFileSeparator(launcher);
            testrunnerFilePath = this.buildTestRunnerPath(params.getPathToTestrunner(), launcher);
            testrunnerFile = new FilePath(this.channel, testrunnerFilePath);
            if (StringUtils.isNotBlank((String)testrunnerFilePath) && testrunnerFile.exists() && testrunnerFile.length() != 0L) {
                try {
                    if (!this.isSoapUIProTestrunner(testrunnerFile)) {
                        out.println("The testrunner file is not correct. Please confirm it's the testrunner for SoapUI Pro. Exiting.");
                        return null;
                    }
                    break block20;
                }
                catch (IOException e) {
                    e.printStackTrace(out);
                    return null;
                }
            }
            out.println("Failed to load testrunner file [" + testrunnerFilePath + "]");
            return null;
        }
        processParameterList.add(testrunnerFilePath);
        this.reportsFolderPath = params.getWorkspace() + this.slaveFileSeparator + READYAPI_REPORT_DIRECTORY + this.slaveFileSeparator;
        this.setReportDirectory(this.reportsFolderPath);
        processParameterList.addAll(Arrays.asList("-f", this.reportsFolderPath));
        processParameterList.add("-r");
        processParameterList.add("-j");
        processParameterList.add("-J");
        processParameterList.addAll(Arrays.asList("-F", REPORT_FORMAT));
        boolean isPrintableReportTypeSet = false;
        String testSuite = params.getTestSuite();
        String testCase = params.getTestCase();
        if (StringUtils.isNotBlank((String)testCase)) {
            if (StringUtils.isNotBlank((String)testSuite)) {
                processParameterList.addAll(Arrays.asList("-c", testCase));
                processParameterList.addAll(Arrays.asList("-R", TESTCASE_REPORT));
                this.setPrintableReportParams(ProcessRunner.createFolderName(testSuite) + this.slaveFileSeparator + ProcessRunner.createFolderName(testCase) + this.slaveFileSeparator, TESTCASE_REPORT);
                isPrintableReportTypeSet = true;
            } else {
                out.println("Enter a testsuite for the specified testcase. Exiting.");
                return null;
            }
        }
        if (StringUtils.isNotBlank((String)testSuite)) {
            processParameterList.addAll(Arrays.asList("-s", testSuite));
            if (!isPrintableReportTypeSet) {
                processParameterList.addAll(Arrays.asList("-R", TESTSUITE_REPORT));
                this.setPrintableReportParams(ProcessRunner.createFolderName(testSuite) + this.slaveFileSeparator, TESTSUITE_REPORT);
                isPrintableReportTypeSet = true;
            }
        }
        if (StringUtils.isNotBlank((String)params.getTestSuiteTags())) {
            processParameterList.addAll(Arrays.asList("-T", "TestSuite " + params.getTestSuiteTags()));
        }
        if (StringUtils.isNotBlank((String)params.getTestCaseTags())) {
            processParameterList.addAll(Arrays.asList("-T", "TestCase " + params.getTestCaseTags()));
        }
        if (StringUtils.isNotBlank((String)params.getProjectPassword())) {
            processParameterList.addAll(Arrays.asList("-x", params.getProjectPassword()));
        }
        if (StringUtils.isNotBlank((String)params.getEnvironment())) {
            processParameterList.addAll(Arrays.asList("-E", params.getEnvironment()));
        }
        String projectFilePath = params.getPathToProjectFile();
        FilePath projectFile = new FilePath(this.channel, projectFilePath);
        if (StringUtils.isNotBlank((String)projectFilePath) && projectFile.exists() && (projectFile.isDirectory() || projectFile.length() != 0L)) {
            try {
                this.checkIfSoapUIProProject(projectFile);
            }
            catch (Exception e) {
                e.printStackTrace(out);
                return null;
            }
            if (!this.isSoapUIProProject) {
                out.println("The project is not a SoapUI Pro project! Exiting.");
                return null;
            }
        } else {
            out.println("Failed to load the project file [" + projectFilePath + "]");
            return null;
        }
        processParameterList.add(projectFilePath);
        if (!isPrintableReportTypeSet) {
            processParameterList.addAll(Arrays.asList("-R", PROJECT_REPORT));
            this.setPrintableReportParams("", PROJECT_REPORT);
            isPrintableReportTypeSet = true;
        }
        if (this.shouldSendAnalytics(testrunnerFile)) {
            Properties properties = new Properties();
            properties.load(ProcessRunner.class.getResourceAsStream(SOAPUI_PRO_FUNCTIONAL_TESTING_PLUGIN_INFO));
            String version = properties.getProperty("version", DEFAULT_PLUGIN_VERSION);
            processParameterList.addAll(Arrays.asList("-q", "Jenkins-" + version));
        }
        this.isReportCreated = false;
        this.isPrintableReportCreated = false;
        Launcher.ProcStarter processStarter = launcher.launch().cmds(processParameterList).envs((Map)run.getEnvironment(listener)).readStdout().quiet(true);
        out.println("Starting SoapUI Pro functional test.");
        final Proc process = processStarter.start();
        final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getStdout()));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String s;
                    while ((s = bufferedReader.readLine()) != null) {
                        out.println(s);
                        if (s.contains(ProcessRunner.TERMINATION_STRING)) {
                            out.println("No license was found! Exiting.");
                            run.setResult(Result.FAILURE);
                            process.kill();
                            return;
                        }
                        if (s.contains(ProcessRunner.REPORT_CREATED_DETERMINANT)) {
                            ProcessRunner.this.isReportCreated = true;
                        }
                        if (!s.contains(ProcessRunner.this.PRINTABLE_REPORT_CREATED_DETERMINATION)) continue;
                        ProcessRunner.this.isPrintableReportCreated = true;
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace(out);
                }
            }
        }).start();
        return process;
    }

    public String getReportsFolderPath() {
        return this.reportsFolderPath;
    }

    private void setSlaveFileSeparator(Launcher launcher) {
        this.slaveFileSeparator = launcher.isUnix() ? "/" : "\\";
    }

    private String buildTestRunnerPath(String pathToTestrunnerFile, Launcher launcher) throws IOException, InterruptedException {
        if (!StringUtils.isNotBlank((String)pathToTestrunnerFile)) {
            return "";
        }
        if (!new FilePath(this.channel, pathToTestrunnerFile).isDirectory()) {
            return pathToTestrunnerFile;
        }
        if (launcher.isUnix()) {
            return pathToTestrunnerFile + this.slaveFileSeparator + TESTRUNNER_NAME + SH;
        }
        return pathToTestrunnerFile + this.slaveFileSeparator + TESTRUNNER_NAME + BAT;
    }

    private boolean isSoapUIProTestrunner(FilePath testrunnerFile) throws IOException, InterruptedException {
        return testrunnerFile.readToString().contains(SOAPUI_PRO_TESTRUNNER_DETERMINANT);
    }

    private void setReportDirectory(String reportDirectoryPath) throws IOException, InterruptedException {
        FilePath reportDirectoryFile = new FilePath(this.channel, reportDirectoryPath);
        if (!reportDirectoryFile.exists()) {
            reportDirectoryFile.mkdirs();
        }
    }

    private void checkIfSoapUIProProject(FilePath projectFile) throws Exception {
        if (projectFile.isDirectory()) {
            this.isSoapUIProProject = true;
            return;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        try {
            saxParser.parse(projectFile.read(), (DefaultHandler)new ReadXmlUpToSpecificElementSaxParser(LAST_ELEMENT_TO_READ));
        }
        catch (MySAXTerminatorException mySAXTerminatorException) {
            // empty catch block
        }
    }

    private boolean shouldSendAnalytics(FilePath testrunnerFile) throws IOException, InterruptedException {
        int secondVersionIndex;
        int startFromIndex;
        int firstVersionNumber;
        String testrunnerFileToString = testrunnerFile.readToString();
        return testrunnerFileToString.contains(TESTRUNNER_VERSION_DETERMINANT) && (firstVersionNumber = Character.getNumericValue(testrunnerFileToString.charAt(startFromIndex = testrunnerFileToString.indexOf(TESTRUNNER_VERSION_DETERMINANT) + TESTRUNNER_VERSION_DETERMINANT.length()))) >= 2 && (secondVersionIndex = Character.getNumericValue(testrunnerFileToString.charAt(startFromIndex + 2))) >= 4;
    }

    private void setPrintableReportParams(String printableReportPath, String printableReportType) {
        this.printableReportPath = printableReportPath;
        this.printableReportName = printableReportType + "." + REPORT_FORMAT.toLowerCase();
        this.PRINTABLE_REPORT_CREATED_DETERMINATION = String.format(this.PRINTABLE_REPORT_CREATED_DETERMINATION, printableReportType);
    }

    private static String createFolderName(String str) {
        StringBuilder result = new StringBuilder();
        for (int c = 0; c < str.length(); ++c) {
            char ch = str.charAt(c);
            if (Character.isWhitespace(ch)) {
                result.append('-');
                continue;
            }
            if (Character.isLetterOrDigit(ch)) {
                result.append(ch);
                continue;
            }
            if (ch != '-') continue;
            result.append(ch);
        }
        return result.toString();
    }

    protected boolean isReportCreated() {
        return this.isReportCreated;
    }

    protected boolean isPrintableReportCreated() {
        return this.isPrintableReportCreated;
    }

    protected String getPrintableReportName() {
        return this.printableReportName;
    }

    protected String getPrintableReportPath() {
        return this.printableReportPath;
    }

    private class MySAXTerminatorException
    extends SAXException {
        private MySAXTerminatorException() {
        }
    }

    private class ReadXmlUpToSpecificElementSaxParser
    extends DefaultHandler {
        private final String lastElementToRead;

        ReadXmlUpToSpecificElementSaxParser(String lastElementToRead) {
            this.lastElementToRead = lastElementToRead;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws MySAXTerminatorException {
            if (this.lastElementToRead.equals(qName)) {
                String value = attributes.getValue(ProcessRunner.ATTRIBUTE_TO_CHECK);
                if (value != null) {
                    ProcessRunner.this.isSoapUIProProject = !value.isEmpty();
                }
                throw new MySAXTerminatorException();
            }
        }
    }
}

