/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.util.VariableResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapException;

public class SkytapUtils {
    public static String expandEnvVars(AbstractBuild build, String targetString) {
        String expandedString = "";
        if (targetString == null || targetString.equals("")) {
            return expandedString;
        }
        try {
            EnvVars env = build.getEnvironment((TaskListener)JenkinsLogger.getListener());
            expandedString = env.expand(targetString);
        }
        catch (IOException e) {
            JenkinsLogger.error("Jenkins Environment variables could not be resolved successfully.");
        }
        catch (InterruptedException e) {
            JenkinsLogger.error("Jenkins Environment variables could not be resolved successfully.");
        }
        catch (NullPointerException e) {
            JenkinsLogger.error("Error. Submitted value was null or empty.");
        }
        if (!expandedString.equals("")) {
            JenkinsLogger.log("Expanding environment variable ...");
            JenkinsLogger.log(targetString + "=>" + expandedString);
        }
        return expandedString;
    }

    public static String getVMIDFromName(String confId, String vname, String authCredentials) throws SkytapException {
        JenkinsLogger.log("Building request url ...");
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(confId);
        sb.append("/vms");
        String getVmIdURL = sb.toString();
        HttpGet hg = SkytapUtils.buildHttpGetRequest(getVmIdURL, authCredentials);
        String hgResponse = "";
        hgResponse = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
        SkytapUtils.checkResponseForErrors(hgResponse);
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(hgResponse);
        JsonArray vmArray = je.getAsJsonArray();
        JenkinsLogger.log("Iterating through vm array to match name: " + vname);
        for (JsonObject vmObject : vmArray) {
            JenkinsLogger.log(vmObject.toString());
            String currentName = vmObject.get("name").getAsString();
            JenkinsLogger.log("Found VM with name: " + currentName);
            if (!currentName.equals(vname)) continue;
            JenkinsLogger.log("Name matched. Retrieving vm id.");
            String vid = vmObject.get("id").getAsString();
            JenkinsLogger.log("VM ID: " + vid);
            return vid;
        }
        throw new SkytapException("No vms were found matching name: " + vname);
    }

    public static String getContainerRegistryIdFromName(String containerRegistryName, String authCredentials) throws SkytapException {
        JenkinsLogger.log("Building request url ...");
        int offset = 0;
        int iteration = 1;
        boolean registryListExists = true;
        while (registryListExists) {
            StringBuilder sb = new StringBuilder("https://cloud.skytap.com/v2/container_registries.json?count=100&offset=" + String.valueOf(offset));
            String getContainerRegistryIdURL = sb.toString();
            HttpGet hg = SkytapUtils.buildHttpGetRequest(getContainerRegistryIdURL, authCredentials);
            String hgResponse = "";
            hgResponse = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
            SkytapUtils.checkResponseForErrors(hgResponse);
            JsonParser parser = new JsonParser();
            JsonElement je = parser.parse(hgResponse);
            JsonArray registryArray = je.getAsJsonArray();
            if (registryArray == null) {
                registryListExists = false;
                continue;
            }
            JenkinsLogger.log("Iterating through container registry array " + String.valueOf(iteration) + " to match name: " + containerRegistryName);
            for (JsonObject registryObject : registryArray) {
                String currentName = registryObject.get("name").getAsString();
                JenkinsLogger.log("Found container registry with name: " + currentName);
                if (!currentName.equals(containerRegistryName)) continue;
                JenkinsLogger.log("Name matched. Retrieving registry id.");
                String rid = registryObject.get("id").getAsString();
                JenkinsLogger.log("Container Registry ID: " + rid);
                return rid;
            }
            offset += 100;
            ++iteration;
        }
        throw new SkytapException("No container registries were found matching name: " + containerRegistryName);
    }

    public static String getVMContainerIdFromName(String confId, String vmId, String containerName, String authCredentials) throws SkytapException {
        int offset = 0;
        int iteration = 1;
        boolean containerListExists = true;
        while (containerListExists) {
            JenkinsLogger.log("Building request url ...");
            StringBuilder sb = new StringBuilder("https://cloud.skytap.com/v2/");
            sb.append("configurations/");
            sb.append(confId);
            sb.append("/containers?count=100&offset=" + String.valueOf(offset) + "&query=vm_id:");
            sb.append(vmId);
            sb.append("&query=name:");
            sb.append(containerName);
            String getVmIdURL = sb.toString();
            HttpGet hg = SkytapUtils.buildHttpGetRequest(getVmIdURL, authCredentials);
            String hgResponse = "";
            hgResponse = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
            SkytapUtils.checkResponseForErrors(hgResponse);
            JsonParser parser = new JsonParser();
            JsonElement je = parser.parse(hgResponse);
            JsonArray containerArray = je.getAsJsonArray();
            if (containerArray == null) {
                containerListExists = false;
                continue;
            }
            JenkinsLogger.log("Iterating through container array " + String.valueOf(iteration) + " to match name: " + containerName);
            for (JsonObject containerObject : containerArray) {
                String currentName = containerObject.get("name").getAsString();
                JenkinsLogger.log("Found container with name: " + currentName);
                if (!currentName.equals(containerName)) continue;
                JenkinsLogger.log("Name matched. Retrieving container id.");
                String containerId = containerObject.get("id").getAsString();
                JenkinsLogger.log("Container ID: " + containerId);
                return containerId;
            }
            offset += 100;
            ++iteration;
        }
        throw new SkytapException("No container was found matching name: " + containerName);
    }

    public static String getEnvContainerIdFromName(String confId, String containerName, String authCredentials) throws SkytapException {
        int offset = 0;
        int iteration = 1;
        boolean containerListExists = true;
        while (containerListExists) {
            JenkinsLogger.log("Building request url ...");
            StringBuilder sb = new StringBuilder("https://cloud.skytap.com/v2/");
            sb.append("configurations/");
            sb.append(confId);
            sb.append("/containers?count=100&offset=" + String.valueOf(offset) + "&query=name:");
            sb.append(containerName);
            String getVmIdURL = sb.toString();
            HttpGet hg = SkytapUtils.buildHttpGetRequest(getVmIdURL, authCredentials);
            String hgResponse = "";
            hgResponse = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
            SkytapUtils.checkResponseForErrors(hgResponse);
            JsonParser parser = new JsonParser();
            JsonElement je = parser.parse(hgResponse);
            JsonArray containerArray = je.getAsJsonArray();
            if (containerArray == null) {
                containerListExists = false;
                continue;
            }
            JenkinsLogger.log("Iterating through container array " + String.valueOf(iteration) + " to match name: " + containerName);
            for (JsonObject containerObject : containerArray) {
                JenkinsLogger.log(containerObject.toString());
                String currentName = containerObject.get("name").getAsString();
                JenkinsLogger.log("Found container with name: " + currentName);
                if (!currentName.equals(containerName)) continue;
                JenkinsLogger.log("Name matched. Retrieving container id.");
                String containerId = containerObject.get("id").getAsString();
                JenkinsLogger.log("Container ID: " + containerId);
                return containerId;
            }
            offset += 100;
            ++iteration;
        }
        throw new SkytapException("No container was found matching name: " + containerName);
    }

    public static JsonObject getJsonObjectFromFile(String filepath) {
        JsonObject jo = null;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(filepath));
            String results = "";
            while ((line = reader.readLine()) != null) {
                results = results + line;
            }
            reader.close();
            JsonParser parser = new JsonParser();
            JsonElement je = parser.parse(results);
            jo = je.getAsJsonObject();
        }
        catch (IOException e) {
            JenkinsLogger.error("Error retrieving JsonObject from file " + filepath + ".");
            JenkinsLogger.error("Error message: " + e.getMessage());
        }
        return jo;
    }

    public static String getValueFromJsonResponseBody(String jsonRespBody, String key) {
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(jsonRespBody);
        JsonObject jo = je.getAsJsonObject();
        jo = je.getAsJsonObject();
        String jsonValue = jo.get(key).getAsString();
        return jsonValue;
    }

    private static String encodeAuthCredentials(String unencodedCredential) {
        byte[] encoded = Base64.encodeBase64((byte[])unencodedCredential.getBytes());
        String encodedCredential = new String(encoded);
        return encodedCredential;
    }

    public static String getAuthCredentials(AbstractBuild build) {
        VariableResolver vr = build.getBuildVariableResolver();
        String uid = vr.resolve("userId").toString();
        String authkey = vr.resolve("authKey").toString();
        String cred = uid + ":" + authkey;
        String encodedCred = SkytapUtils.encodeAuthCredentials(cred);
        return encodedCred;
    }

    public static HttpGet buildHttpGetRequest(String requestUrl, String AuthToken) {
        HttpGet hg = new HttpGet(requestUrl);
        String authHeaderValue = "Basic " + AuthToken;
        hg.addHeader("Authorization", authHeaderValue);
        hg.addHeader("Accept", "application/json");
        hg.addHeader("Content-Type", "application/json");
        JenkinsLogger.log("HTTP GET Request: " + hg.toString());
        return hg;
    }

    public static HttpPost buildHttpPostRequest(String requestUrl, String AuthToken) {
        HttpPost hp = new HttpPost(requestUrl);
        String authHeaderValue = "Basic " + AuthToken;
        hp.addHeader("Authorization", authHeaderValue);
        hp.addHeader("Accept", "application/json");
        hp.addHeader("Content-Type", "application/json");
        JenkinsLogger.log("HTTP POST Request: " + hp.toString());
        return hp;
    }

    public static HttpPut buildHttpPutRequest(String requestUrl, String AuthToken) {
        HttpPut httpput = new HttpPut(requestUrl);
        String authHeaderValue = "Basic " + AuthToken;
        httpput.addHeader("Authorization", authHeaderValue);
        httpput.addHeader("Accept", "application/json");
        httpput.addHeader("Content-Type", "application/json");
        JenkinsLogger.log("HTTP PUT Request: " + httpput.toString());
        return httpput;
    }

    public static HttpDelete buildHttpDeleteRequest(String requestUrl, String AuthToken) {
        HttpDelete hd = new HttpDelete(requestUrl);
        String authHeaderValue = "Basic " + AuthToken;
        hd.addHeader("Authorization", authHeaderValue);
        hd.addHeader("Accept", "application/json");
        hd.addHeader("Content-Type", "application/json");
        JenkinsLogger.log("HTTP DELETE Request: " + hd.toString());
        return hd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeHttpRequest(HttpRequestBase hr) throws SkytapException {
        boolean retryHttpRequest = true;
        int retryCount = 1;
        String responseString = "";
        boolean useproxy = false;
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPortStr = System.getProperty("http.proxyPort");
        String proxyProtocol = null;
        int proxyPort = 0;
        HttpHost proxy = null;
        if (proxyHost == null) {
            proxyHost = System.getProperty("https.proxyHost");
            proxyPortStr = System.getProperty("https.proxyPort");
            if (proxyHost != null) {
                proxyPort = Integer.parseInt(proxyPortStr);
                proxyProtocol = "https";
                useproxy = true;
            }
        } else {
            proxyPort = Integer.parseInt(proxyPortStr);
            proxyProtocol = "http";
            useproxy = true;
        }
        while (retryHttpRequest) {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpclient.getParams(), (int)60000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpclient.getParams(), (int)60000);
            if (useproxy) {
                proxy = new HttpHost(proxyHost, proxyPort, proxyProtocol);
                httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
            responseString = "";
            HttpResponse response = null;
            try {
                Date myDate = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd:HH-mm-ss");
                String myDateString = sdf.format(myDate);
                if (useproxy) {
                    JenkinsLogger.log(myDateString + "\nUsing proxy: " + proxyProtocol + "://" + proxyHost + ":" + proxyPort);
                }
                JenkinsLogger.log(myDateString + "\nExecuting Request: " + hr.getRequestLine());
                response = httpclient.execute((HttpUriRequest)hr);
                String responseStatusLine = response.getStatusLine().toString();
                if (responseStatusLine.contains("423 Locked") || responseStatusLine.contains("422 Unprocessable Entity")) {
                    if (++retryCount > 5) {
                        retryHttpRequest = false;
                        JenkinsLogger.error("Object busy too long - giving up.");
                        continue;
                    }
                    JenkinsLogger.log("Object busy - Retrying...");
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException e1) {
                        JenkinsLogger.error(e1.getMessage());
                    }
                    continue;
                }
                if (responseStatusLine.contains("409 Conflict")) {
                    throw new SkytapException(responseStatusLine);
                }
                JenkinsLogger.log(response.getStatusLine().toString());
                HttpEntity entity = response.getEntity();
                responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                retryHttpRequest = false;
            }
            catch (HttpResponseException e) {
                retryHttpRequest = false;
                JenkinsLogger.error("HTTP Response Code: " + e.getStatusCode());
            }
            catch (ParseException e) {
                retryHttpRequest = false;
                JenkinsLogger.error(e.getMessage());
            }
            catch (InterruptedIOException e) {
                Date myDate = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd:HH-mm-ss");
                String myDateString = sdf.format(myDate);
                if (++retryCount > 5) {
                    retryHttpRequest = false;
                    JenkinsLogger.error("API Timeout - giving up. " + e.getMessage());
                    continue;
                }
                JenkinsLogger.log(myDateString + "\n" + e.getMessage() + "\nAPI Timeout - Retrying...");
            }
            catch (IOException e) {
                retryHttpRequest = false;
                JenkinsLogger.error(e.getMessage());
            }
            finally {
                if (response != null) {
                    HttpEntity entity = response.getEntity();
                    try {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    }
                    catch (IOException sdf) {}
                }
                httpclient.getConnectionManager().shutdown();
            }
        }
        return responseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeHttpDeleteRequest(HttpDelete hd) {
        String responseString = "";
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpResponse response = null;
        JenkinsLogger.log("Executing Request: " + hd.getRequestLine());
        try {
            response = httpclient.execute((HttpUriRequest)hd);
            String statusLine = response.getStatusLine().toString();
            JenkinsLogger.log(statusLine);
            HttpEntity entity = response.getEntity();
            responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (HttpResponseException e) {
            JenkinsLogger.error("HTTP Response Code: " + e.getStatusCode());
        }
        catch (ParseException e) {
            JenkinsLogger.error(e.getMessage());
        }
        catch (IOException e) {
            JenkinsLogger.error(e.getMessage());
        }
        finally {
            HttpEntity entity = response.getEntity();
            try {
                responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            catch (IOException iOException) {}
            httpclient.getConnectionManager().shutdown();
        }
        return responseString;
    }

    public static void checkResponseForErrors(String response) throws SkytapException {
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(response);
        JsonObject jo = null;
        if (je.isJsonNull()) {
            return;
        }
        if (je.isJsonArray()) {
            return;
        }
        je = parser.parse(response);
        jo = je.getAsJsonObject();
        if (!jo.has("error") && !jo.has("errors")) {
            return;
        }
        if (jo.has("errors")) {
            String errorString = "";
            JsonArray skytapErrors = (JsonArray)je.getAsJsonObject().get("errors");
            for (JsonElement errorElem : skytapErrors) {
                String errMsg = errorElem.toString();
                errorString = errorString + errMsg + "\n";
            }
            throw new SkytapException(errorString);
        }
        if (jo.has("error")) {
            if (jo.get("error").isJsonNull()) {
                return;
            }
            if (jo.get("error").isJsonPrimitive()) {
                String error = jo.get("error").getAsString();
                if (error.equals("false")) {
                    return;
                }
                if (error.equals("true")) {
                    throw new SkytapException(error);
                }
                if (!error.equals("")) {
                    throw new SkytapException(error);
                }
            }
        }
    }

    public static String getRuntimeId(String usersId, String usersFile) throws FileNotFoundException {
        String runtimeID = "";
        if (!usersFile.equals("")) {
            JenkinsLogger.log("User provided file: " + usersFile);
            JsonObject jo = SkytapUtils.getJsonObjectFromFile(usersFile);
            if (jo == null) {
                JenkinsLogger.error("Unable to read file: " + usersFile);
                throw new FileNotFoundException("Unable to read file: " + usersFile);
            }
            runtimeID = jo.get("id").getAsString();
        } else {
            runtimeID = usersId;
        }
        return runtimeID;
    }

    public static String getProjectID(String projName, String authCredentials) {
        String response;
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com");
        sb.append("/projects");
        HttpGet hg = SkytapUtils.buildHttpGetRequest(sb.toString(), authCredentials);
        try {
            response = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Exception: " + e.getMessage());
            return "";
        }
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(response);
        JsonArray ja = je.getAsJsonArray();
        for (JsonElement projElement : ja) {
            String projElementName = projElement.getAsJsonObject().get("name").getAsString();
            if (!projElementName.equals(projName)) continue;
            String projElementId = projElement.getAsJsonObject().get("id").getAsString();
            return projElementId;
        }
        JenkinsLogger.error("No project matching name \"" + projName + "\" was found.");
        return "";
    }

    public static String convertFileNameToFullPath(AbstractBuild build, String savefile) {
        FilenameUtils fu = new FilenameUtils();
        if (FilenameUtils.getPath((String)savefile).equals("")) {
            JenkinsLogger.log("File: " + savefile + " was specified without a path. Defaulting path to Jenkins workspace.");
            String workspacePath = SkytapUtils.expandEnvVars(build, "${WORKSPACE}");
            savefile = workspacePath + File.separator + savefile;
            savefile = FilenameUtils.separatorsToSystem((String)savefile);
            return savefile;
        }
        return FilenameUtils.separatorsToSystem((String)savefile);
    }

    public static String getNetworkIdFromName(String confId, String netName, String authCredential) throws SkytapException {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(confId);
        String reqUrl = sb.toString();
        HttpGet hg = SkytapUtils.buildHttpGetRequest(reqUrl, authCredential);
        String httpRespBody = "";
        httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
        SkytapUtils.checkResponseForErrors(httpRespBody);
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(httpRespBody);
        JsonArray networkArray = (JsonArray)je.getAsJsonObject().get("networks");
        JenkinsLogger.log("Searching environments's networks for network: " + netName);
        for (JsonElement networkElement : networkArray) {
            String networkElementName = networkElement.getAsJsonObject().get("name").getAsString();
            JenkinsLogger.log("Network Name: " + networkElementName);
            if (!networkElementName.equals(netName)) continue;
            String networkElementId = networkElement.getAsJsonObject().get("id").getAsString();
            JenkinsLogger.log("Network Name Matched.");
            JenkinsLogger.log("Network ID: " + networkElementId);
            return networkElementId;
        }
        throw new SkytapException("No network matching name \"" + netName + "\" is associated with environments id " + confId + ".");
    }
}

