/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.FileNotFoundException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ChangeContainerStateStep
extends SkytapBuilder.SkytapAction {
    private final String containerID;
    private final String containerFile;
    private final String targetContainerAction;
    private static final int NUMBER_OF_RETRIES = 5;
    private static final int BASE_RETRY_INTERVAL_SECONDS = 20;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String authCredentials;
    @XStreamOmitField
    private String runtimeContainerID;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(ChangeContainerStateStep.class, "Change Container State");

    @DataBoundConstructor
    public ChangeContainerStateStep(String containerID, String containerFile, String targetContainerAction) {
        super("Change Container State");
        this.containerID = containerID;
        this.containerFile = containerFile;
        this.targetContainerAction = targetContainerAction;
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Changing Container State");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expContainerFile = SkytapUtils.expandEnvVars(build, this.containerFile);
        if (!expContainerFile.equals("")) {
            expContainerFile = SkytapUtils.convertFileNameToFullPath(build, expContainerFile);
        }
        try {
            this.runtimeContainerID = SkytapUtils.getRuntimeId(this.containerID, expContainerFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error obtaining runtime container id: " + e.getMessage());
            return false;
        }
        String targetContainerState = "";
        if (this.targetContainerAction.equals("start") || this.targetContainerAction.equals("unpause")) {
            targetContainerState = "running";
        }
        if (this.targetContainerAction.equals("pause")) {
            targetContainerState = "paused";
        }
        if (this.targetContainerAction.equals("stop") || this.targetContainerAction.equals("kill")) {
            targetContainerState = "exited";
        }
        JenkinsLogger.log("Runtime Container ID: " + this.runtimeContainerID);
        JenkinsLogger.log("Container File: " + expContainerFile);
        JenkinsLogger.log("Target Container Action: " + this.targetContainerAction);
        JenkinsLogger.log("Target Container Runstate: " + targetContainerState);
        String currentRunState = "";
        try {
            currentRunState = this.getCurrentContainerRunstate(this.runtimeContainerID);
        }
        catch (SkytapException e2) {
            JenkinsLogger.error("Error obtaining current container runstate: " + e2.getMessage());
            return false;
        }
        JenkinsLogger.log("Current Container Runstate: " + currentRunState);
        if (targetContainerState.equals(currentRunState)) {
            JenkinsLogger.defaultLogMessage("Info: Current container runstate appears to be equal to target container runstate. Skipping this step.");
            JenkinsLogger.defaultLogMessage("----------------------------------------");
            return true;
        }
        if (!this.isContainerStateTransitionValid(currentRunState, this.targetContainerAction).booleanValue()) {
            JenkinsLogger.defaultLogMessage("Skytap will not permit a container \"" + this.targetContainerAction + "\" action from a \"" + currentRunState + "\" state");
            JenkinsLogger.defaultLogMessage("Aborting build step.");
            JenkinsLogger.defaultLogMessage("----------------------------------------");
            return false;
        }
        this.sendStateChangeRequest(this.runtimeContainerID, this.targetContainerAction);
        int i = 1;
        while (true) {
            if (i > 5) break;
            try {
                int sleepTime = 20 * i;
                JenkinsLogger.log("Sleeping for " + sleepTime + " seconds.");
                Thread.sleep(sleepTime * 1000);
            }
            catch (InterruptedException e1) {
                JenkinsLogger.error(e1.getMessage());
            }
            JenkinsLogger.log("Checking environment runstate..");
            try {
                currentRunState = this.getCurrentContainerRunstate(this.runtimeContainerID);
            }
            catch (SkytapException e) {
                JenkinsLogger.error("Error retrieving current container runstate: " + e.getMessage());
            }
            JenkinsLogger.log("Current Container Runstate=" + currentRunState);
            if (currentRunState.equals(targetContainerState)) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    JenkinsLogger.error("Error: " + e.getMessage());
                }
                JenkinsLogger.defaultLogMessage("Container Runstate transitioned successfully.");
                JenkinsLogger.defaultLogMessage("----------------------------------------");
                return true;
            }
            if (!currentRunState.equals("busy")) {
                this.sendStateChangeRequest(this.runtimeContainerID, this.targetContainerAction);
            }
            ++i;
        }
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return false;
    }

    private Boolean preFlightSanityChecks() {
        if (!this.containerID.equals("") && !this.containerFile.equals("")) {
            JenkinsLogger.error("Values were provided for both environment ID and file. Please provide just one or the other.");
            JenkinsLogger.defaultLogMessage("----------------------------------------");
            return false;
        }
        if (this.containerFile.equals("") && this.containerID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            JenkinsLogger.defaultLogMessage("----------------------------------------");
            return false;
        }
        return true;
    }

    private void sendStateChangeRequest(String containId, String containAction) {
        JenkinsLogger.log("Sending state change request for container id " + containId + ". Target action is " + containAction);
        String requestURL = this.buildRequestURL(containId, containAction);
        HttpPut hp = SkytapUtils.buildHttpPutRequest(requestURL, this.authCredentials);
        String httpRespBody = "";
        try {
            SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error("Skytap Error: " + e1.getMessage());
        }
        try {
            SkytapUtils.checkResponseForErrors(httpRespBody);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Error: " + e.getError());
        }
    }

    private String buildRequestURL(String containId, String runstate) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("v2/containers/");
        sb.append(containId);
        sb.append("?runstate=");
        sb.append(runstate);
        return sb.toString();
    }

    private Boolean isContainerStateTransitionValid(String currentState, String targetAction) {
        if (currentState.equals("exited") && targetAction.equals("pause")) {
            return false;
        }
        if (currentState.equals("paused") && !targetAction.equals("unpause")) {
            return false;
        }
        if (targetAction.equals("unpause") && !currentState.equals("paused")) {
            return false;
        }
        return true;
    }

    private String getCurrentContainerRunstate(String skytapContainerId) throws SkytapException {
        JenkinsLogger.log("Retrieving Current Container Runstate ...");
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("v2/containers/");
        sb.append(skytapContainerId);
        sb.append(".json");
        String getRequest = sb.toString();
        HttpGet hg = SkytapUtils.buildHttpGetRequest(getRequest, this.authCredentials);
        String getResponse = "";
        try {
            getResponse = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
        }
        catch (Exception e) {
            throw new SkytapException(e.getMessage());
        }
        String skytapRunstate = "";
        try {
            skytapRunstate = SkytapUtils.getValueFromJsonResponseBody(getResponse, "status");
        }
        catch (NullPointerException ex) {
            throw new SkytapException("Response was null or empty.");
        }
        return skytapRunstate;
    }

    public String getContainerID() {
        return this.containerID;
    }

    public String getContainerFile() {
        return this.containerFile;
    }

    public String getTargetContainerAction() {
        return this.targetContainerAction;
    }
}

