/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class DeleteConfigurationStep
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    private static final int NUMBER_OF_RETRIES = 18;
    private static final int RETRY_INTERVAL_SECONDS = 10;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String authCredentials;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(DeleteConfigurationStep.class, "Delete Environment");

    @DataBoundConstructor
    public DeleteConfigurationStep(String configurationID, String configurationFile) {
        super("Delete Configuration");
        this.configurationID = configurationID;
        this.configurationFile = configurationFile;
    }

    private ArrayList getTunnelList(String configId) throws SkytapException {
        ArrayList<String> tunnelIdList = new ArrayList<String>();
        String listNetworksURL = this.buildNetworkListURL(configId);
        JenkinsLogger.log("Getting network list for environment with id: " + configId);
        HttpGet hg = SkytapUtils.buildHttpGetRequest(listNetworksURL, this.authCredentials);
        String httpRespBody = "";
        httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
        SkytapUtils.checkResponseForErrors(httpRespBody);
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(httpRespBody);
        JsonArray ja = je.getAsJsonArray();
        for (JsonElement networkElement : ja) {
            String networkId = networkElement.getAsJsonObject().get("id").getAsString();
            JenkinsLogger.log("Getting tunnels for network with id: " + networkId);
            JsonElement tunnelsElement = networkElement.getAsJsonObject().get("tunnels");
            JsonArray tunnelArray = tunnelsElement.getAsJsonArray();
            for (int i = 0; i < tunnelArray.size(); ++i) {
                JsonElement tunnelElement = tunnelArray.get(i);
                String id = tunnelElement.getAsJsonObject().get("id").getAsString();
                JenkinsLogger.log("Adding tunnel: " + id + " to list.");
                tunnelIdList.add(id);
            }
        }
        return tunnelIdList;
    }

    private String buildNetworkListURL(String configId) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(configId);
        sb.append("/networks");
        return sb.toString();
    }

    private String buildDisconnectTunnelURL(String tunnelId) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("tunnels/");
        sb.append(tunnelId);
        sb.append("/");
        return sb.toString();
    }

    private void disconnectTunnel(String tid) throws SkytapException {
        JenkinsLogger.log("Disconnecting tunnel with id: " + tid);
        String reqUrl = this.buildDisconnectTunnelURL(tid);
        String httpRespBody = "";
        HttpDelete hd = SkytapUtils.buildHttpDeleteRequest(reqUrl, this.authCredentials);
        httpRespBody = SkytapUtils.executeHttpDeleteRequest(hd);
        if (httpRespBody.equals("")) {
            throw new SkytapException("An error occurred while attempting to disconnect " + tid);
        }
        JenkinsLogger.log("Tunnel " + tid + " was disconnected successfully.");
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Delete Environment");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expConfigurationFile = SkytapUtils.expandEnvVars(build, this.configurationFile);
        if (!expConfigurationFile.equals("")) {
            expConfigurationFile = SkytapUtils.convertFileNameToFullPath(build, expConfigurationFile);
        }
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(this.configurationID, expConfigurationFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error retrieving environment id: " + e.getMessage());
            return false;
        }
        JenkinsLogger.log("Checking for any connected networks for environment id: " + this.runtimeConfigurationID);
        ArrayList tunnelIdList = new ArrayList();
        try {
            tunnelIdList = this.getTunnelList(this.runtimeConfigurationID);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error(e1.getMessage());
            return false;
        }
        JenkinsLogger.log("Disconnecting connected networks ...");
        for (int i = 0; i < tunnelIdList.size(); ++i) {
            String tunnelId = tunnelIdList.get(i).toString();
            try {
                this.disconnectTunnel(tunnelId);
                continue;
            }
            catch (SkytapException e) {
                JenkinsLogger.error(e.getMessage());
                return false;
            }
        }
        JenkinsLogger.log("Sending delete request for environment id " + this.runtimeConfigurationID);
        if (!this.attemptDeleteConfiguration(this.runtimeConfigurationID).booleanValue()) {
            JenkinsLogger.error("Environment ID: " + this.runtimeConfigurationID + " could not be deleted. Failing build step.");
            return false;
        }
        JenkinsLogger.defaultLogMessage("Environment " + this.runtimeConfigurationID + " was successfully deleted.");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return true;
    }

    private Boolean attemptDeleteConfiguration(String confId) {
        String requestURL = this.buildRequestURL(confId);
        HttpDelete hd = SkytapUtils.buildHttpDeleteRequest(requestURL, this.authCredentials);
        String httpRespBody = "";
        Boolean configDeletedSuccessfully = false;
        int pollAttempts = 0;
        while (!configDeletedSuccessfully.booleanValue()) {
            if (pollAttempts >= 18) break;
            int sleepTime = 10;
            JenkinsLogger.log("Sleeping for " + sleepTime + " seconds.");
            try {
                Thread.sleep(sleepTime * 1000);
            }
            catch (InterruptedException e1) {
                JenkinsLogger.error(e1.getMessage());
            }
            httpRespBody = SkytapUtils.executeHttpDeleteRequest(hd);
            if (httpRespBody.equals("")) {
                JenkinsLogger.error("An error occurred while attempting to delete " + confId);
                ++pollAttempts;
                continue;
            }
            configDeletedSuccessfully = true;
        }
        return configDeletedSuccessfully;
    }

    private String buildRequestURL(String configId) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(configId);
        return sb.toString();
    }

    private Boolean preFlightSanityChecks() {
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both environment ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            return false;
        }
        return true;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }
}

