/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BasicHttpEntity;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class CreatePublishURLStep
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    private final String urlSaveFilename;
    private final String portalName;
    private final String permissionOption;
    private final Boolean hasPassword;
    private final String urlPassword;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @XStreamOmitField
    private String authCredentials;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(CreatePublishURLStep.class, "Create Sharing Portal");

    @DataBoundConstructor
    public CreatePublishURLStep(String configurationID, String configurationFile, String urlSaveFilename, String portalName, String permissionOption, RequirePasswordBlock hasPassword) {
        super("Create Published URL");
        this.configurationFile = configurationFile;
        this.configurationID = configurationID;
        this.urlSaveFilename = urlSaveFilename;
        this.permissionOption = permissionOption;
        this.portalName = portalName == null ? "Default Publish Set" : portalName;
        if (hasPassword == null) {
            this.hasPassword = false;
            this.urlPassword = null;
        } else {
            this.hasPassword = true;
            this.urlPassword = hasPassword.password;
        }
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Creating Sharing Portal");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expConfigFile = SkytapUtils.expandEnvVars(build, this.configurationFile);
        if (!expConfigFile.equals("")) {
            expConfigFile = SkytapUtils.convertFileNameToFullPath(build, expConfigFile);
        }
        String expUrlFile = SkytapUtils.expandEnvVars(build, this.urlSaveFilename);
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(this.configurationID, expConfigFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error retrieving environment id: " + e.getMessage());
            return false;
        }
        JenkinsLogger.log("Retrieving VM ids for environment: " + this.runtimeConfigurationID);
        ArrayList<String> vmList = new ArrayList();
        try {
            vmList = this.getVMIds(this.runtimeConfigurationID);
        }
        catch (SkytapException e) {
            JenkinsLogger.error(e.getMessage());
            return false;
        }
        JenkinsLogger.log("Creating publish set ...");
        String pubSetUrl = "";
        try {
            pubSetUrl = this.createPublishSet(this.runtimeConfigurationID, vmList);
        }
        catch (SkytapException e) {
            JenkinsLogger.error(e.getMessage());
        }
        JenkinsLogger.log("Sharing Portal URL: " + pubSetUrl);
        BufferedWriter output = null;
        expUrlFile = SkytapUtils.convertFileNameToFullPath(build, expUrlFile);
        File file = new File(expUrlFile);
        try {
            output = new BufferedWriter(new FileWriter(file));
            output.write(pubSetUrl);
            ((Writer)output).close();
        }
        catch (IOException e) {
            JenkinsLogger.error("Skytap Plugin failed to save URL to file: " + expUrlFile);
            return false;
        }
        JenkinsLogger.defaultLogMessage("URL " + pubSetUrl + " successfully created and saved to file: " + expUrlFile);
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return true;
    }

    private String createPublishSet(String confId, List<String> vmList) throws SkytapException {
        String reqUrl = "https://cloud.skytap.com/configurations/" + confId + "/publish_sets/";
        JenkinsLogger.log("Request URL: " + reqUrl);
        HttpPost hp = SkytapUtils.buildHttpPostRequest(reqUrl, this.authCredentials);
        BasicHttpEntity he = new BasicHttpEntity();
        he.setContentEncoding("gzip");
        he.setContentType("application/json");
        StringBuilder sb = new StringBuilder("");
        sb.append("{\"publish_set\":{\"publish_set_type\":\"single_url\",");
        sb.append("\"vms\":[");
        Iterator<String> iter = vmList.iterator();
        while (iter.hasNext()) {
            String vmString = "{\"access\":\"" + this.permissionOption + "\",\"vm_ref\":\"" + iter.next().toString() + "\"}";
            if (iter.hasNext()) {
                vmString = vmString + ",";
            }
            sb.append(vmString);
        }
        String passwordString = "";
        passwordString = this.hasPassword != false ? "\"" + this.urlPassword + "\"" : "null";
        sb.append("],\"password\":" + passwordString + ",");
        sb.append("\"name\":\"" + this.portalName + "\"}}");
        String jsonString = sb.toString();
        JenkinsLogger.log("Request Payload: " + jsonString);
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes("UTF-8"));
            Integer len = jsonString.getBytes("UTF-8").length;
            long llen = len.longValue();
            he.setContent((InputStream)stream);
            he.setContentLength(llen);
        }
        catch (UnsupportedEncodingException e) {
            JenkinsLogger.error("Error encoding json string for connected attribute: " + e.getMessage());
        }
        hp.setEntity((HttpEntity)he);
        String response = "";
        response = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        SkytapUtils.checkResponseForErrors(response);
        String respUrl = SkytapUtils.getValueFromJsonResponseBody(response, "desktops_url");
        return respUrl;
    }

    private List<String> getVMIds(String confId) throws SkytapException {
        ArrayList<String> vmList = new ArrayList<String>();
        String reqUrl = "https://cloud.skytap.com/configurations/" + confId;
        HttpGet hg = SkytapUtils.buildHttpGetRequest(reqUrl, this.authCredentials);
        String response = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
        SkytapUtils.checkResponseForErrors(response);
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(response);
        JsonArray ja = (JsonArray)je.getAsJsonObject().get("vms");
        for (JsonElement vmElement : ja) {
            String vmElementId = vmElement.getAsJsonObject().get("id").getAsString();
            vmList.add(vmElementId);
            JenkinsLogger.log("VM ID: " + vmElementId);
        }
        return vmList;
    }

    private Boolean preFlightSanityChecks() {
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both environment ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            return false;
        }
        if (this.urlSaveFilename.equals("")) {
            JenkinsLogger.error("No value was provided for URL save file. Please provide a valid filename.");
            return false;
        }
        if (this.hasPassword.booleanValue() && this.urlPassword.equals("")) {
            JenkinsLogger.error("It was indicated the URL should have a password but none was provided. Please provide a password.");
            return false;
        }
        return true;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public String getUrlSaveFilename() {
        return this.urlSaveFilename;
    }

    public String getPermissionOption() {
        return this.permissionOption;
    }

    public Boolean isHasPassword() {
        return this.hasPassword;
    }

    public Boolean getHasPassword() {
        return this.hasPassword;
    }

    public String getUrlPassword() {
        return this.urlPassword;
    }

    public String getPortalName() {
        return this.portalName;
    }

    public static class RequirePasswordBlock {
        private String password;

        @DataBoundConstructor
        public RequirePasswordBlock(String urlPassword) {
            this.password = urlPassword;
        }
    }
}

