/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.util.VariableResolver;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapException;

public class SkytapUtils {
    public static String expandEnvVars(AbstractBuild build, String targetString) {
        String expandedString = "";
        if (targetString == null || targetString.equals("")) {
            return expandedString;
        }
        try {
            EnvVars env = build.getEnvironment((TaskListener)JenkinsLogger.getListener());
            expandedString = env.expand(targetString);
        }
        catch (IOException e) {
            JenkinsLogger.error("Jenkins Environment variables could not be resolved successfully.");
        }
        catch (InterruptedException e) {
            JenkinsLogger.error("Jenkins Environment variables could not be resolved successfully.");
        }
        catch (NullPointerException e) {
            JenkinsLogger.error("Error. Submitted value was null or empty.");
        }
        if (!expandedString.equals("")) {
            JenkinsLogger.log("Expanding environment variable ...");
            JenkinsLogger.log(targetString + "=>" + expandedString);
        }
        return expandedString;
    }

    public static JsonObject getJsonObjectFromFile(String filepath) {
        JsonObject jo = null;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(filepath));
            String results = "";
            while ((line = reader.readLine()) != null) {
                results = results + line;
            }
            reader.close();
            JsonParser parser = new JsonParser();
            JsonElement je = parser.parse(results);
            jo = je.getAsJsonObject();
        }
        catch (IOException e) {
            JenkinsLogger.error("Error retrieving JsonObject from file " + filepath + ".");
            JenkinsLogger.error("Error message: " + e.getMessage());
        }
        return jo;
    }

    public static String getValueFromJsonResponseBody(String jsonRespBody, String key) {
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(jsonRespBody);
        JsonObject jo = je.getAsJsonObject();
        jo = je.getAsJsonObject();
        String jsonValue = jo.get(key).getAsString();
        return jsonValue;
    }

    private static String encodeAuthCredentials(String unencodedCredential) {
        byte[] encoded = Base64.encodeBase64((byte[])unencodedCredential.getBytes());
        String encodedCredential = new String(encoded);
        return encodedCredential;
    }

    public static String getAuthCredentials(AbstractBuild build) {
        VariableResolver vr = build.getBuildVariableResolver();
        String uid = vr.resolve("userId").toString();
        String authkey = vr.resolve("authKey").toString();
        String cred = uid + ":" + authkey;
        String encodedCred = SkytapUtils.encodeAuthCredentials(cred);
        return encodedCred;
    }

    public static HttpGet buildHttpGetRequest(String requestUrl, String AuthToken) {
        HttpGet hg = new HttpGet(requestUrl);
        String authHeaderValue = "Basic " + AuthToken;
        hg.addHeader("Authorization", authHeaderValue);
        hg.addHeader("Accept", "application/json");
        hg.addHeader("Content-Type", "application/json");
        JenkinsLogger.log("HTTP GET Request: " + hg.toString());
        return hg;
    }

    public static HttpPost buildHttpPostRequest(String requestUrl, String AuthToken) {
        HttpPost hp = new HttpPost(requestUrl);
        String authHeaderValue = "Basic " + AuthToken;
        hp.addHeader("Authorization", authHeaderValue);
        hp.addHeader("Accept", "application/json");
        hp.addHeader("Content-Type", "application/json");
        JenkinsLogger.log("HTTP POST Request: " + hp.toString());
        return hp;
    }

    public static HttpPut buildHttpPutRequest(String requestUrl, String AuthToken) {
        HttpPut httpput = new HttpPut(requestUrl);
        String authHeaderValue = "Basic " + AuthToken;
        httpput.addHeader("Authorization", authHeaderValue);
        httpput.addHeader("Accept", "application/json");
        httpput.addHeader("Content-Type", "application/json");
        JenkinsLogger.log("HTTP PUT Request: " + httpput.toString());
        return httpput;
    }

    public static HttpDelete buildHttpDeleteRequest(String requestUrl, String AuthToken) {
        HttpDelete hd = new HttpDelete(requestUrl);
        String authHeaderValue = "Basic " + AuthToken;
        hd.addHeader("Authorization", authHeaderValue);
        hd.addHeader("Accept", "application/json");
        hd.addHeader("Content-Type", "application/json");
        JenkinsLogger.log("HTTP DELETE Request: " + hd.toString());
        return hd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeHttpRequest(HttpRequestBase hr) throws SkytapException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        String responseString = "";
        HttpResponse response = null;
        try {
            JenkinsLogger.log("Executing Request: " + hr.getRequestLine());
            response = httpclient.execute((HttpUriRequest)hr);
            JenkinsLogger.log(response.getStatusLine().toString());
            HttpEntity entity = response.getEntity();
            responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (HttpResponseException e) {
            JenkinsLogger.error("HTTP Response Code: " + e.getStatusCode());
        }
        catch (ParseException e) {
            JenkinsLogger.error(e.getMessage());
        }
        catch (IOException e) {
            JenkinsLogger.error(e.getMessage());
        }
        finally {
            HttpEntity entity = response.getEntity();
            try {
                responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            catch (IOException e) {}
            httpclient.getConnectionManager().shutdown();
        }
        return responseString;
    }

    public static String executeHttpDeleteRequest(HttpDelete hd) {
        String responseString = "";
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)hd);
            String statusLine = response.getStatusLine().toString();
            JenkinsLogger.log(statusLine);
            HttpEntity entity = response.getEntity();
            responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ClientProtocolException e) {
            JenkinsLogger.error("HTTP Error: " + e.getMessage());
        }
        catch (IOException e) {
            JenkinsLogger.error("An error occurred executing the http request: " + e.getMessage());
        }
        return "";
    }

    public static void checkResponseForErrors(String response) throws SkytapException {
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(response);
        JsonObject jo = null;
        if (je.isJsonNull()) {
            return;
        }
        jo = je.getAsJsonObject();
        je = parser.parse(response);
        jo = je.getAsJsonObject();
        if (!jo.has("error") && !jo.has("errors")) {
            return;
        }
        if (jo.has("errors")) {
            String errorString = "";
            JsonArray skytapErrors = (JsonArray)je.getAsJsonObject().get("errors");
            for (JsonElement errorElem : skytapErrors) {
                String errMsg = errorElem.toString();
                errorString = errorString + errMsg + "\n";
            }
            throw new SkytapException(errorString);
        }
        if (jo.has("error")) {
            if (jo.get("error").isJsonNull()) {
                return;
            }
            String error = jo.get("error").getAsString();
            if (!error.equals("")) {
                throw new SkytapException(error);
            }
        }
    }

    public static String getRuntimeId(String usersId, String usersFile) throws FileNotFoundException {
        String runtimeID = "";
        if (!usersFile.equals("")) {
            JenkinsLogger.log("User provided file: " + usersFile);
            JsonObject jo = SkytapUtils.getJsonObjectFromFile(usersFile);
            if (jo == null) {
                JenkinsLogger.error("Unable to read file: " + usersFile);
                throw new FileNotFoundException("Unable to read file: " + usersFile);
            }
            runtimeID = jo.get("id").getAsString();
        } else {
            runtimeID = usersId;
        }
        return runtimeID;
    }

    public static String getNetworkIdFromName(String confId, String netName, String authCredential) throws SkytapException {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(confId);
        String reqUrl = sb.toString();
        HttpGet hg = SkytapUtils.buildHttpGetRequest(reqUrl, authCredential);
        String httpRespBody = "";
        httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
        SkytapUtils.checkResponseForErrors(httpRespBody);
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(httpRespBody);
        JsonArray networkArray = (JsonArray)je.getAsJsonObject().get("networks");
        JenkinsLogger.log("Searching configuration's networks for network: " + netName);
        for (JsonElement networkElement : networkArray) {
            String networkElementName = networkElement.getAsJsonObject().get("name").getAsString();
            JenkinsLogger.log("Network Name: " + networkElementName);
            if (!networkElementName.equals(netName)) continue;
            String networkElementId = networkElement.getAsJsonObject().get("id").getAsString();
            JenkinsLogger.log("Network Name Matched.");
            JenkinsLogger.log("Network ID: " + networkElementId);
            return networkElementId;
        }
        throw new SkytapException("No network matching name \"" + netName + "\"" + " is associated with configuration id " + confId + ".");
    }
}

