/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.FileNotFoundException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class NetworkConnectStep
extends SkytapBuilder.SkytapAction {
    private final String sourceNetworkConfigurationID;
    private final String targetNetworkConfigurationID;
    private final String sourceNetworkConfigurationFile;
    private final String targetNetworkConfigurationFile;
    private final String sourceNetworkName;
    private final String targetNetworkName;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String runtimeSourceNetworkConfigurationID;
    @XStreamOmitField
    private String runtimeTargetNetworkConfigurationID;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(NetworkConnectStep.class, "Connect to Network in another Configuration (ICNR)");

    @DataBoundConstructor
    public NetworkConnectStep(String sourceNetworkConfigurationID, String targetNetworkConfigurationID, String sourceNetworkConfigurationFile, String targetNetworkConfigurationFile, String sourceNetworkName, String targetNetworkName) {
        super("Connect to Network in another Configuration (ICNR)");
        this.sourceNetworkConfigurationID = sourceNetworkConfigurationID;
        this.targetNetworkConfigurationID = targetNetworkConfigurationID;
        this.sourceNetworkConfigurationFile = sourceNetworkConfigurationFile;
        this.targetNetworkConfigurationFile = targetNetworkConfigurationFile;
        this.sourceNetworkName = sourceNetworkName;
        this.targetNetworkName = targetNetworkName;
    }

    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Connecting to Network in another Configuration");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        String expSourceNetworkConfigurationFile = SkytapUtils.expandEnvVars(build, this.sourceNetworkConfigurationFile);
        String expTargetNetworkConfigurationFile = SkytapUtils.expandEnvVars(build, this.targetNetworkConfigurationFile);
        try {
            this.runtimeSourceNetworkConfigurationID = SkytapUtils.getRuntimeId(this.sourceNetworkConfigurationID, expSourceNetworkConfigurationFile);
            this.runtimeTargetNetworkConfigurationID = SkytapUtils.getRuntimeId(this.targetNetworkConfigurationID, expTargetNetworkConfigurationFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error obtaining runtime id: " + e.getMessage());
            return false;
        }
        String runtimeSourceNetworkID = "";
        String runtimeTargetNetworkID = "";
        try {
            runtimeSourceNetworkID = SkytapUtils.getNetworkIdFromName(this.runtimeSourceNetworkConfigurationID, this.sourceNetworkName, this.globalVars.getEncodedCredentials());
        }
        catch (SkytapException e1) {
            JenkinsLogger.error(e1.getError());
            return false;
        }
        try {
            runtimeTargetNetworkID = SkytapUtils.getNetworkIdFromName(this.runtimeTargetNetworkConfigurationID, this.targetNetworkName, this.globalVars.getEncodedCredentials());
        }
        catch (SkytapException e1) {
            JenkinsLogger.error(e1.getError());
            return false;
        }
        if (runtimeSourceNetworkID.equals("") || runtimeTargetNetworkID.equals("")) {
            JenkinsLogger.error("Unable to obtain network identifiers.");
            return false;
        }
        try {
            this.sendNetConnectRequest(runtimeSourceNetworkID, runtimeTargetNetworkID);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Error: " + e.getMessage());
            return false;
        }
        JenkinsLogger.defaultLogMessage("Networks " + this.sourceNetworkName + " and " + this.targetNetworkName + " have been connected successfully.");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return true;
    }

    private void sendNetConnectRequest(String sourceNetId, String targetNetId) throws SkytapException {
        JenkinsLogger.log("Sending network connection request for source: " + sourceNetId + " to target: " + targetNetId);
        String requestURL = this.buildRequestURL(sourceNetId, targetNetId);
        HttpPost hp = SkytapUtils.buildHttpPostRequest(requestURL, this.globalVars.getEncodedCredentials());
        String httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        if (httpRespBody.equals("")) {
            throw new SkytapException("Request Failed. No HTTP response was returned.");
        }
        SkytapUtils.checkResponseForErrors(httpRespBody);
    }

    private String buildRequestURL(String sid, String tid) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("tunnels?");
        sb.append("source_network_id=");
        sb.append(sid);
        sb.append("&target_network_id=");
        sb.append(tid);
        return sb.toString();
    }

    private Boolean preFlightSanityChecks() {
        if (!this.sourceNetworkConfigurationFile.equals("") && !this.sourceNetworkConfigurationID.equals("")) {
            JenkinsLogger.error("Values were provided for both source configuration ID and file. Please provide just one or the other.");
            return false;
        }
        if (!this.targetNetworkConfigurationFile.equals("") && !this.targetNetworkConfigurationID.equals("")) {
            JenkinsLogger.error("Values were provided for both target configuration ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.sourceNetworkConfigurationFile.equals("") && this.sourceNetworkConfigurationID.equals("")) {
            JenkinsLogger.error("No value was provided for configuration ID or file. Please provide either a valid Skytap configuration ID, or a valid configuration file.");
            return false;
        }
        if (this.targetNetworkConfigurationFile.equals("") && this.targetNetworkConfigurationID.equals("")) {
            JenkinsLogger.error("No value was provided for configuration ID or file. Please provide either a valid Skytap configuration ID, or a valid configuration file.");
            return false;
        }
        if (this.targetNetworkName.equals("")) {
            JenkinsLogger.error("No value was provided for target network name. Please provide a valid target network name.");
            return false;
        }
        if (this.sourceNetworkName.equals("")) {
            JenkinsLogger.error("No value was provided for source network name. Please provide a valid source network name.");
            return false;
        }
        return true;
    }

    public SkytapGlobalVariables getGlobalVars() {
        return this.globalVars;
    }

    public String getSourceNetworkConfigurationID() {
        return this.sourceNetworkConfigurationID;
    }

    public String getTargetNetworkConfigurationID() {
        return this.targetNetworkConfigurationID;
    }

    public String getSourceNetworkConfigurationFile() {
        return this.sourceNetworkConfigurationFile;
    }

    public String getTargetNetworkConfigurationFile() {
        return this.targetNetworkConfigurationFile;
    }

    public String getSourceNetworkName() {
        return this.sourceNetworkName;
    }

    public String getTargetNetworkName() {
        return this.targetNetworkName;
    }
}

