/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sharedobjects.type;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import org.jenkinsci.plugins.sharedobjects.SharedObjectType;
import org.jenkinsci.plugins.sharedobjects.SharedObjectTypeDescriptor;
import org.jenkinsci.plugins.sharedobjects.SimpleSharedObjectType;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectLogger;
import org.kohsuke.stapler.DataBoundConstructor;

public class PublicFilePathSharedObjectType
extends SimpleSharedObjectType {
    private String publicFilePath;

    @DataBoundConstructor
    public PublicFilePathSharedObjectType(String name, String profiles, String publicFilePath) {
        super(name, profiles);
        this.publicFilePath = Util.fixEmptyAndTrim((String)publicFilePath);
    }

    public String getPublicFilePath() {
        return this.publicFilePath;
    }

    public String getEnvVarValue(AbstractBuild build, SharedObjectLogger logger) {
        logger.info(String.format("Populating the file path %s associated to the shared object with the name %s.", this.publicFilePath, this.name));
        return this.publicFilePath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class PublicFilePathSharedObjectTypeDescriptor
    extends SharedObjectTypeDescriptor {
        public String getDisplayName() {
            return "Public File Path";
        }

        @Override
        public Class<? extends SharedObjectType> getType() {
            return PublicFilePathSharedObjectType.class;
        }
    }
}

