/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sharedobjects;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributor;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributorDescriptor;
import org.jenkinsci.plugins.sharedobjects.SharedObjectException;
import org.jenkinsci.plugins.sharedobjects.SharedObjectType;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectDataStore;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectLogger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedObjectJobProperty
extends EnvInjectJobPropertyContributor {
    private boolean populateSharedObjects;
    private String profiles;

    public SharedObjectJobProperty() {
    }

    @DataBoundConstructor
    public SharedObjectJobProperty(boolean populateSharedObjects, String profiles) {
        this.populateSharedObjects = populateSharedObjects;
        this.profiles = profiles;
    }

    public boolean isPopulateSharedObjects() {
        return this.populateSharedObjects;
    }

    public String getProfiles() {
        return this.profiles;
    }

    public void init() {
        this.populateSharedObjects = true;
    }

    public Map<String, String> getEnvVars(TaskListener listener) throws EnvInjectException {
        SharedObjectLogger logger = new SharedObjectLogger(listener);
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.populateSharedObjects) {
            logger.info("Injecting shared objects as environment variables");
            try {
                SharedObjectType[] sharedObjectTypes = (SharedObjectType[])Hudson.getInstance().getRootPath().act((Callable)new Callable<SharedObjectType[], EnvInjectException>(){

                    public SharedObjectType[] call() throws EnvInjectException {
                        SharedObjectDataStore dataStore = new SharedObjectDataStore();
                        try {
                            return dataStore.readSharedObjectsFile();
                        }
                        catch (SharedObjectException e) {
                            throw new EnvInjectException((Throwable)e);
                        }
                    }
                });
                if (sharedObjectTypes != null) {
                    for (SharedObjectType type : sharedObjectTypes) {
                        if (type == null || !this.isProfilActivated(this.profiles, type)) continue;
                        result.put(type.getName(), type.getEnvVarValue(logger));
                    }
                }
            }
            catch (SharedObjectException se) {
                throw new EnvInjectException((Throwable)se);
            }
            catch (IOException e) {
                throw new EnvInjectException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new EnvInjectException((Throwable)e);
            }
        }
        return result;
    }

    private boolean isProfilActivated(String profiles, SharedObjectType type) {
        if (profiles == null) {
            return true;
        }
        if (profiles.trim().length() == 0) {
            return true;
        }
        String typeProfile = type.getProfile();
        if (typeProfile == null) {
            return true;
        }
        if (typeProfile.length() == 0) {
            return true;
        }
        return Arrays.asList(profiles.split(";")).contains(typeProfile);
    }

    @Extension
    public static class SharedObjectJobPropertyDescriptor
    extends EnvInjectJobPropertyContributorDescriptor {
        public String getDisplayName() {
            return "Populate shared objects";
        }
    }
}

