/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sharedobjects.type;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jenkinsci.plugins.sharedobjects.MultipleSharedObjectType;
import org.jenkinsci.plugins.sharedobjects.SharedObjectException;
import org.jenkinsci.plugins.sharedobjects.SharedObjectType;
import org.jenkinsci.plugins.sharedobjects.SharedObjectTypeDescriptor;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectLogger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLPropertiesSharedObjectType
extends MultipleSharedObjectType {
    private String url;

    @DataBoundConstructor
    public URLPropertiesSharedObjectType(String name, String profiles, String url) {
        super(name, profiles);
        this.url = Util.fixEmpty((String)url);
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public Map<String, String> getEnvVars(AbstractBuild build, SharedObjectLogger logger) throws SharedObjectException {
        logger.info(String.format("Trying to retrieve a properties file through the url value %s associated to the shared object with the name %s.", this.url, this.name));
        if (this.url == null) {
            return null;
        }
        DefaultClientConfig cc = new DefaultClientConfig();
        Client client = Client.create((ClientConfig)cc);
        client.setConnectTimeout(Integer.valueOf(300000));
        client.setReadTimeout(Integer.valueOf(300000));
        ClientResponse clientResponse = (ClientResponse)client.resource(this.url).get(ClientResponse.class);
        String propertiesContent = (String)clientResponse.getEntity(String.class);
        if (propertiesContent == null) {
            return null;
        }
        return this.loadProperties(propertiesContent);
    }

    private Map<String, String> loadProperties(String content) throws SharedObjectException {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties properties = new Properties();
        StringReader stringReader = new StringReader(content);
        try {
            properties.load(stringReader);
        }
        catch (IOException ioe) {
            throw new SharedObjectException(ioe);
        }
        stringReader.close();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            result.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class URLPropertiesSharedObjectTypeDescriptor
    extends SharedObjectTypeDescriptor {
        public String getDisplayName() {
            return "A URL to a properties file";
        }

        @Override
        public Class<? extends SharedObjectType> getType() {
            return URLPropertiesSharedObjectType.class;
        }
    }
}

