/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.SemanticVersioning;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.SemanticVersioning.InjectVersionVarsAction;
import org.jenkinsci.plugins.SemanticVersioning.SemanticVersioningCallable;
import org.jenkinsci.plugins.SemanticVersioning.SemanticVersioningResult;
import org.jenkinsci.plugins.SemanticVersioning.naming.NamingStrategy;
import org.jenkinsci.plugins.SemanticVersioning.naming.NoopNamingStrategy;
import org.jenkinsci.plugins.SemanticVersioning.parsing.BuildDefinitionParser;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class SemanticVersioningBuilder
extends Builder {
    private BuildDefinitionParser parser;
    private NamingStrategy namingStrategy = new NoopNamingStrategy();
    private String envVariable = "BUILD_VERSION";
    private boolean useJenkinsBuildNumber;
    @Extension
    public static final SemanticVersioningBuilderDescriptor descriptor = new SemanticVersioningBuilderDescriptor();

    @DataBoundConstructor
    public SemanticVersioningBuilder(String parser, String namingStrategy, boolean useJenkinsBuildNumber, String envVariable) {
        this.useJenkinsBuildNumber = useJenkinsBuildNumber;
        this.envVariable = envVariable;
        try {
            this.parser = (BuildDefinitionParser)Jenkins.getActiveInstance().getExtensionList(parser).iterator().next();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.namingStrategy = (NamingStrategy)Jenkins.getActiveInstance().getExtensionList(namingStrategy).iterator().next();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            this.namingStrategy = new NoopNamingStrategy();
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean getUseJenkinsBuildNumber() {
        return this.useJenkinsBuildNumber;
    }

    public String getParser() {
        return this.parser.getClass().getCanonicalName();
    }

    public String getNamingStrategy() {
        return this.namingStrategy.getClass().getCanonicalName();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        SemanticVersioningCallable svc = new SemanticVersioningCallable();
        int buildNumber = -1;
        try {
            buildNumber = Integer.parseInt((String)build.getEnvironment(TaskListener.NULL).get((Object)"BUILD_NUMBER"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        svc.setBuildNumber(buildNumber);
        svc.setEnv(this.envVariable);
        svc.setNamingStrategy(this.namingStrategy);
        svc.setParser(this.parser);
        svc.setUseBuildNumber(this.useJenkinsBuildNumber);
        svc.setWorkspace(build.getWorkspace());
        logger.println("SemanticVersioning callable ... ");
        SemanticVersioningResult svr = (SemanticVersioningResult)launcher.getChannel().call((Callable)svc);
        if (svr.getLog() != null) {
            for (String s : svr.getLog()) {
                for (String sx : s.split("[\\n\\r]+")) {
                    logger.println("SemanticVersioning REMOTE: " + sx);
                }
            }
        }
        if (svr.getVars() != null) {
            logger.println("SemanticVersioning adding injectVars action ...");
            build.addAction((Action)new InjectVersionVarsAction(svr.getVars()));
            logger.println("SemanticVersioning adding injectVars action ... DONE!");
        }
        logger.println("SemanticVersioning callable ... DONE!");
        logger.println("SemanticVersioning writing to file: " + svr.getVersion() + " ... ");
        this.writeVersionToFile(build, svr.getVersion());
        logger.println("SemanticVersioning writing to file: " + svr.getVersion() + " ... DONE!");
        return true;
    }

    private void writeVersionToFile(AbstractBuild<?, ?> build, String reportedVersion) {
        String filename = build.getRootDir() + "/" + ".semanticVersion";
        File file = new File(filename);
        try {
            FileUtils.writeStringToFile((File)file, (String)(reportedVersion + "\n"));
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public String getEnvVariable() {
        return this.envVariable;
    }

    public void setEnvVariable(String envVariable) {
        this.envVariable = envVariable;
    }

    @Extension(ordinal=9999.0)
    public static final class SemanticVersioningBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        public SemanticVersioningBuilderDescriptor() {
            super(SemanticVersioningBuilder.class);
            this.load();
        }

        public ListBoxModel doFillParserItems() {
            ListBoxModel parsersModel = new ListBoxModel();
            for (BuildDefinitionParser parser : Jenkins.getActiveInstance().getExtensionList(BuildDefinitionParser.class)) {
                parsersModel.add(parser.getDescriptor().getDisplayName(), parser.getClass().getCanonicalName());
            }
            return parsersModel;
        }

        public ListBoxModel doFillNamingStrategyItems() {
            ListBoxModel namingStrategiesModel = new ListBoxModel();
            for (NamingStrategy namingStrategy : Jenkins.getActiveInstance().getExtensionList(NamingStrategy.class)) {
                namingStrategiesModel.add(namingStrategy.getDescriptor().getDisplayName(), namingStrategy.getClass().getCanonicalName());
            }
            return namingStrategiesModel;
        }

        public boolean getDefaultUseJenkinsBuildNumber() {
            return true;
        }

        public String getDisplayName() {
            return "Determine Semantic Version";
        }

        public boolean isApplicable(Class clazz) {
            return true;
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)super.newInstance(req, formData);
        }
    }
}

