/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.SemanticVersioning.parsing;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jenkinsci.plugins.SemanticVersioning.AppVersion;
import org.jenkinsci.plugins.SemanticVersioning.InvalidBuildFileFormatException;
import org.jenkinsci.plugins.SemanticVersioning.parsing.AbstractBuildDefinitionParser;
import org.jenkinsci.plugins.SemanticVersioning.parsing.AbstractSemanticParserDescription;
import org.jenkinsci.plugins.SemanticVersioning.parsing.BuildDefinitionParser;
import org.jenkinsci.remoting.RoleChecker;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Extension
public class PomParser
extends AbstractBuildDefinitionParser {
    private static final String BUILD_FILE = "pom.xml";

    @Override
    public AppVersion extractAppVersion(FilePath workspace, PrintStream logger) throws IOException, InvalidBuildFileFormatException {
        String version = null;
        Document document = this.getPom(workspace);
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            XPathExpression expression = xPath.compile("/project/version");
            version = expression.evaluate(document);
        }
        catch (XPathExpressionException e) {
            throw new InvalidBuildFileFormatException(document.getBaseURI() + " is not a valid POM file.");
        }
        if (version == null || version.length() == 0) {
            throw new InvalidBuildFileFormatException("No version information found in " + document.getBaseURI());
        }
        return AppVersion.parse(version);
    }

    private Document getPom(FilePath workspace) throws InvalidBuildFileFormatException, IOException {
        Document pomDocument;
        FilePath pom = new FilePath(workspace, BUILD_FILE);
        try {
            pomDocument = (Document)pom.act((FilePath.FileCallable)new FilePath.FileCallable<Document>(){
                private static final long serialVersionUID = 1L;

                public Document invoke(File pom, VirtualChannel channel) throws IOException, InterruptedException {
                    try {
                        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        return documentBuilder.parse(pom);
                    }
                    catch (SAXException e) {
                        throw new InterruptedException(pom.getAbsolutePath() + " is not a valid POM file.");
                    }
                    catch (ParserConfigurationException e) {
                        throw new InterruptedException(pom.getAbsolutePath() + " is not a valid POM file.");
                    }
                }

                public void checkRoles(RoleChecker arg0) throws SecurityException {
                }
            });
        }
        catch (InterruptedException e) {
            throw new InvalidBuildFileFormatException(e.getMessage());
        }
        return pomDocument;
    }

    public Descriptor<BuildDefinitionParser> getDescriptor() {
        return new AbstractSemanticParserDescription(){

            @Override
            public String getDisplayName() {
                return "Maven Pom Parser";
            }
        };
    }
}

