/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.SemanticVersioning.columnDisplay;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.SemanticVersioning.AppVersion;
import org.jenkinsci.plugins.SemanticVersioning.columnDisplay.AbstractColumnDisplayStrategy;
import org.jenkinsci.plugins.SemanticVersioning.columnDisplay.AbstractDisplayStrategyDescription;
import org.jenkinsci.plugins.SemanticVersioning.columnDisplay.ColumnDisplayStrategy;

@Extension
public class LastSuccessfulBuildStrategy
extends AbstractColumnDisplayStrategy {
    private static Logger logger = Logger.getLogger(String.valueOf(AppVersion.class));

    @Override
    public String getDisplayString(Job job) {
        String semanticVersion = null;
        Run run = job.getLastSuccessfulBuild();
        if (run == null) {
            logger.info("LastSuccessfulBuildStrategy::getDisplayString -> last successful build not found.");
            semanticVersion = "Unknown";
        } else {
            String filename = run.getRootDir() + "/" + ".semanticVersion";
            logger.info("LastSuccessfulBuildStrategy::getDisplayString -> last successful build found. Filename -> " + filename);
            File file = new File(filename);
            if (file.exists()) {
                try {
                    semanticVersion = FileUtils.readFileToString((File)file);
                    logger.info("LastSuccessfulBuildStrategy::getDisplayString -> read semantic version from file -> " + semanticVersion);
                }
                catch (IOException e) {
                    logger.severe(e.toString());
                }
            } else {
                logger.info("LastSuccessfulBuildStrategy::getDisplayString -> semanticVersion file not found.");
                semanticVersion = "Unknown";
            }
        }
        return semanticVersion;
    }

    public Descriptor<ColumnDisplayStrategy> getDescriptor() {
        return new AbstractDisplayStrategyDescription(){

            @Override
            public String getDisplayName() {
                return "Show Last Successful Semantic Version";
            }
        };
    }
}

