/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.process;

import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.plugins.selenium.HubHolder;
import hudson.plugins.selenium.PluginImpl;
import hudson.plugins.selenium.callables.RemoveSeleniumServer;
import hudson.plugins.selenium.callables.RunningRemoteSetterCallable;
import hudson.plugins.selenium.callables.SeleniumCallable;
import hudson.plugins.selenium.callables.StopSeleniumServer;
import hudson.plugins.selenium.process.SeleniumProcess;
import hudson.plugins.selenium.process.SeleniumProcessUtils;
import hudson.plugins.selenium.process.SeleniumRunOptions;
import hudson.remoting.Callable;
import java.io.IOException;
import jenkins.security.MasterToSlaveCallable;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.RemoteProxy;

public abstract class SeleniumJarRunner
implements SeleniumProcess {
    public abstract SeleniumRunOptions initOptions(Computer var1);

    @Override
    public void start(Computer computer, TaskListener listener, String name) throws IOException, InterruptedException {
        PluginImpl p = PluginImpl.getPlugin();
        FilePath seleniumJar = new FilePath(SeleniumProcessUtils.findStandAloneServerJar());
        FilePath htmlUnitDriverJar = new FilePath(SeleniumProcessUtils.findHtmlUnitDriverJar());
        String nodeName = computer.getName();
        String masterName = PluginImpl.getMasterHostName();
        String nodehost = computer.getHostName();
        SeleniumRunOptions opts = this.initOptions(computer);
        if (opts != null) {
            opts.addOptionIfSet("-host", nodehost);
            computer.getNode().getRootPath().act((FilePath.FileCallable)new SeleniumCallable(seleniumJar, htmlUnitDriverJar, nodehost, masterName, p.getPort(), nodeName, listener, name, opts));
        }
    }

    public void remove(Computer computer, String name) {
        this.stop(computer, name);
        try {
            computer.getNode().getRootPath().act((Callable)new RemoveSeleniumServer(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void stop(Computer computer, String name) {
        FilePath path = computer.getNode().getRootPath();
        if (path != null) {
            try {
                final String url = (String)computer.getNode().getRootPath().act((Callable)new StopSeleniumServer(name));
                PluginImpl.getPlugin().getHubChannel().call((Callable)new MasterToSlaveCallable<Void, Exception>(){
                    private static final long serialVersionUID = -5805313572457450300L;
                    private String remoteUrl;
                    {
                        this.remoteUrl = url;
                    }

                    public Void call() throws Exception {
                        GridRegistry registry = HubHolder.getHub().getRegistry();
                        if (registry != null) {
                            for (RemoteProxy proxy : registry.getAllProxies()) {
                                if (!this.remoteUrl.equals(proxy.getRemoteHost().toString())) continue;
                                registry.removeIfPresent(proxy);
                            }
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                try {
                    computer.getNode().getRootPath().act((Callable)new RunningRemoteSetterCallable(name, "Error"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

