/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration.global.matcher;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.plugins.selenium.configuration.global.matcher.SeleniumConfigurationMatcher;
import hudson.util.FormValidation;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

@Extension
public class NodeLabelMatcher
extends SeleniumConfigurationMatcher {
    private static final long serialVersionUID = -7254869163456438031L;
    private String labelExpr;

    public NodeLabelMatcher() {
    }

    @DataBoundConstructor
    public NodeLabelMatcher(String label) {
        this.labelExpr = label;
    }

    @Override
    public boolean match(Node node) {
        if (node == null) {
            return false;
        }
        try {
            return Label.parseExpression((String)this.labelExpr).matches(node);
        }
        catch (ANTLRException aNTLRException) {
            return false;
        }
    }

    @Exported
    public String getLabel() {
        return this.labelExpr;
    }

    @Override
    public String getSummary() {
        return this.getDescriptor().getDisplayName() + " (Expression = '" + this.labelExpr + "' )";
    }

    @Extension
    public static class DescriptorImpl
    extends SeleniumConfigurationMatcher.MatcherDescriptor {
        public String getDisplayName() {
            return "Match nodes from a label expression";
        }

        public FormValidation doCheckLabel(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public AutoCompletionCandidates doAutoCompleteLabel() {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            List masterNodeList = Jenkins.getInstance().getNodes();
            for (Node node : masterNodeList) {
                try {
                    for (LabelAtom atom : Label.parseExpression((String)node.getLabelString()).listAtoms()) {
                        candidates.add(atom.getName());
                    }
                }
                catch (ANTLRException aNTLRException) {
                }
            }
            return candidates;
        }
    }
}

