/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration.browser.webdriver;

import hudson.Extension;
import hudson.model.Computer;
import hudson.plugins.selenium.configuration.browser.IeDriverServerUtils;
import hudson.plugins.selenium.configuration.browser.webdriver.DriverRequiredWebDriverBrowser;
import hudson.plugins.selenium.configuration.browser.webdriver.WebDriverBrowser;
import hudson.plugins.selenium.process.SeleniumRunOptions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class IEBrowser
extends DriverRequiredWebDriverBrowser {
    private static final long serialVersionUID = -241845413478474187L;
    private final transient String ieDriverProperty = "webdriver.ie.driver";
    private transient boolean forbid64bitDriver;
    @Deprecated
    private transient String server_binary;

    @DataBoundConstructor
    public IEBrowser(int maxInstances, String version, String driverBinaryPath, boolean forbid64bitDriver) {
        super(maxInstances, version, "internet explorer", driverBinaryPath);
        this.forbid64bitDriver = forbid64bitDriver;
    }

    @Override
    public Map<String, String> getJVMArgs() {
        HashMap<String, String> args = new HashMap<String, String>();
        IEBrowser.combine(args, "webdriver.ie.driver", this.getDriverBinaryPath());
        return args;
    }

    @Override
    public void initOptions(Computer c, SeleniumRunOptions opt) {
        String driverPath = IeDriverServerUtils.uploadIEDriverIfNecessary(c, this.getDriverBinaryPath(), this.getForbid64bitDriver());
        if (driverPath != null) {
            opt.getJVMArguments().put("webdriver.ie.driver", driverPath);
        }
        opt.addOptionIfSet("-browser", StringUtils.join(this.initBrowserOptions(c, opt), (String)","));
    }

    @Deprecated
    public String getServer_binary() {
        return this.server_binary;
    }

    public Object readResolve() {
        if (this.server_binary != null) {
            this.setDriverBinaryPath(this.server_binary);
        }
        return this;
    }

    @Exported
    public boolean getForbid64bitDriver() {
        return this.forbid64bitDriver;
    }

    @Extension
    public static class DescriptorImpl
    extends WebDriverBrowser.WebDriverBrowserDescriptor {
        @Override
        public int getMaxInstances() {
            return 1;
        }

        public String getDisplayName() {
            return "Internet Explorer";
        }
    }
}

