/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration.browser.webdriver;

import hudson.Extension;
import hudson.model.Computer;
import hudson.plugins.selenium.configuration.browser.webdriver.WebDriverBrowser;
import hudson.plugins.selenium.process.SeleniumRunOptions;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class FirefoxBrowser
extends WebDriverBrowser {
    private static final long serialVersionUID = 1451746845341944745L;
    private final transient String paramBinaryPath = "firefox_binary";
    private String binaryPath;
    @Deprecated
    private transient String binary_path;

    @DataBoundConstructor
    public FirefoxBrowser(int maxInstances, String version, String binaryPath) {
        super(maxInstances, version, "firefox");
        this.binaryPath = binaryPath;
    }

    @Exported
    public String getBinaryPath() {
        return this.binaryPath;
    }

    @Override
    public List<String> initBrowserOptions(Computer c, SeleniumRunOptions options) {
        List<String> args = super.initBrowserOptions(c, options);
        FirefoxBrowser.combine(args, "firefox_binary", (Object)this.getBinaryPath());
        return args;
    }

    @Deprecated
    public String getBinary_path() {
        return this.binary_path;
    }

    public Object readResolve() {
        if (this.binary_path != null) {
            this.binaryPath = this.binary_path;
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends WebDriverBrowser.WebDriverBrowserDescriptor {
        @Override
        public int getMaxInstances() {
            return 5;
        }

        public String getDisplayName() {
            return "Firefox";
        }
    }
}

