/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration.browser;

import hudson.ExtensionPoint;
import hudson.model.Computer;
import hudson.plugins.selenium.process.SeleniumRunOptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.openqa.grid.common.SeleniumProtocol;

@ExportedBean
public abstract class AbstractSeleniumBrowser<T extends AbstractSeleniumBrowser<T>>
implements ExtensionPoint,
Serializable {
    private static final long serialVersionUID = -1895158524568642537L;
    protected final transient String paramBrowserName = "browserName";
    protected final transient String paramMaxInstances = "maxInstances";
    protected final transient String paramVersion = "version";
    protected final transient String paramSeleniumProtocol = "seleniumProtocol";
    private int maxInstances = 0;
    private String version;
    private SeleniumProtocol protocol;
    private String name;

    protected AbstractSeleniumBrowser(SeleniumProtocol protocol, int instances, String version, String name) {
        if (protocol == null) {
            throw new NullPointerException();
        }
        this.maxInstances = instances;
        this.version = version;
        this.protocol = protocol;
        this.name = name;
    }

    @Exported
    public int getMaxInstances() {
        return this.maxInstances;
    }

    @Exported
    public String getVersion() {
        return this.version;
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public String getProtocol() {
        return this.protocol.toString();
    }

    protected static void combine(List<String> options, String key, Object value) {
        if (value != null && !StringUtils.isBlank((String)value.toString())) {
            options.add(key + "=" + value.toString().replace("\"", "\\\""));
        }
    }

    protected static void combine(Map<String, String> args, String key, String value) {
        if (!StringUtils.isBlank((String)value)) {
            args.put(key, value);
        }
    }

    public void initOptions(Computer c, SeleniumRunOptions opt) {
        opt.getJVMArguments().putAll(this.getJVMArgs());
        opt.addOptionIfSet("-browser", StringUtils.join(this.initBrowserOptions(c, opt), (String)","));
    }

    protected List<String> initBrowserOptions(Computer c, SeleniumRunOptions options) {
        ArrayList<String> args = new ArrayList<String>();
        AbstractSeleniumBrowser.combine(args, "seleniumProtocol", this.protocol);
        AbstractSeleniumBrowser.combine(args, "browserName", (Object)this.getName());
        AbstractSeleniumBrowser.combine(args, "maxInstances", this.maxInstances);
        AbstractSeleniumBrowser.combine(args, "version", (Object)this.version);
        return args;
    }

    protected Map<String, String> getJVMArgs() {
        return Collections.emptyMap();
    }
}

