/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.plugins.selenium.callables.RetrieveAvailablePort;
import hudson.plugins.selenium.configuration.ConfigurationDescriptor;
import hudson.plugins.selenium.configuration.SeleniumNodeConfiguration;
import hudson.plugins.selenium.configuration.browser.webdriver.ChromeBrowser;
import hudson.plugins.selenium.configuration.browser.webdriver.FirefoxBrowser;
import hudson.plugins.selenium.configuration.browser.webdriver.IEBrowser;
import hudson.plugins.selenium.configuration.browser.webdriver.WebDriverBrowser;
import hudson.plugins.selenium.process.SeleniumRunOptions;
import hudson.remoting.Callable;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public class CustomWDConfiguration
extends SeleniumNodeConfiguration {
    private static final Logger LOGGER = Logger.getLogger(CustomWDConfiguration.class.getName());
    private static final long serialVersionUID = -1357952133882786829L;
    private int port = 4444;
    private Integer maxSession = 5;
    private Integer timeout = -1;
    private List<WebDriverBrowser> browsers = new ArrayList<WebDriverBrowser>();

    private CustomWDConfiguration() {
        super(null);
        this.browsers.add(new IEBrowser(1, "", "", false));
        this.browsers.add(new FirefoxBrowser(5, "", ""));
        this.browsers.add(new ChromeBrowser(5, "", ""));
    }

    @DataBoundConstructor
    public CustomWDConfiguration(int port, Integer timeout, List<WebDriverBrowser> browsers, String display, Integer maxSession) {
        super(display);
        this.port = port;
        this.timeout = timeout;
        this.browsers = browsers;
        this.maxSession = maxSession;
    }

    @Exported
    public int getPort() {
        return this.port;
    }

    @Exported
    public Integer getTimeout() {
        return this.timeout;
    }

    @Exported
    public Integer getMaxSession() {
        return this.maxSession;
    }

    @Exported
    public List<WebDriverBrowser> getBrowsers() {
        return this.browsers;
    }

    @Override
    public SeleniumRunOptions initOptions(Computer c) {
        SeleniumRunOptions opt = super.initOptions(c);
        try {
            opt.addOptionIfSet("-port", c.getChannel().call((Callable)new RetrieveAvailablePort(this.getPort())));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "an error occured, not adding the port option", e);
        }
        if (this.getTimeout() != null && this.getTimeout() > -1) {
            opt.addOption("-timeout");
            opt.addOption(this.getTimeout().toString());
        }
        if (this.getMaxSession() != null && this.getMaxSession() > 0) {
            opt.addOption("-maxSession");
            opt.addOption(this.getMaxSession().toString());
        }
        for (WebDriverBrowser b : this.browsers) {
            b.initOptions(c, opt);
        }
        return opt;
    }

    @Override
    public String getIcon() {
        return "/plugin/selenium/24x24/internet-web-browser.png";
    }

    @Extension
    public static class DescriptorImpl
    extends ConfigurationDescriptor {
        public String getDisplayName() {
            return "Custom web driver node configuration";
        }

        public CustomWDConfiguration getDefault() {
            return new CustomWDConfiguration();
        }

        public static List<Descriptor<WebDriverBrowser>> getBrowserTypes() {
            ArrayList<Descriptor<WebDriverBrowser>> lst = new ArrayList<Descriptor<WebDriverBrowser>>();
            for (WebDriverBrowser.WebDriverBrowserDescriptor b : WebDriverBrowser.all()) {
                lst.add(b);
            }
            return lst;
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            try {
                Integer i = Integer.parseInt(value);
                if (i >= -1) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Must be an integer greater than or equal to -1.");
        }

        public FormValidation doCheckMaxSession(@QueryParameter String value) {
            try {
                Integer i = Integer.parseInt(value);
                if (i >= 1) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Must be an integer greater than or equal to 1.");
        }
    }
}

