/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.plugins.selenium.callables.RetrieveAvailablePort;
import hudson.plugins.selenium.configuration.ConfigurationDescriptor;
import hudson.plugins.selenium.configuration.SeleniumNodeConfiguration;
import hudson.plugins.selenium.configuration.browser.selenium.ChromeBrowser;
import hudson.plugins.selenium.configuration.browser.selenium.FirefoxBrowser;
import hudson.plugins.selenium.configuration.browser.selenium.IEBrowser;
import hudson.plugins.selenium.configuration.browser.selenium.SeleniumBrowser;
import hudson.plugins.selenium.process.SeleniumRunOptions;
import hudson.remoting.Callable;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public class CustomRCConfiguration
extends SeleniumNodeConfiguration {
    private static final long serialVersionUID = 140690678989633328L;
    private int port = 4444;
    private boolean rcBrowserSideLog;
    private boolean rcDebug;
    private boolean rcTrustAllSSLCerts;
    private boolean rcBrowserSessionReuse;
    private Integer timeout = -1;
    private String rcLog;
    private List<SeleniumBrowser> browsers = new ArrayList<SeleniumBrowser>();

    private CustomRCConfiguration() {
        super(null);
        this.browsers.add(new IEBrowser(1, "", "", false));
        this.browsers.add(new FirefoxBrowser(5, "", ""));
        this.browsers.add(new ChromeBrowser(5, "", ""));
    }

    @DataBoundConstructor
    public CustomRCConfiguration(int port, boolean rcBrowserSideLog, boolean rcDebug, boolean rcTrustAllSSLCerts, boolean rcBrowserSessionReuse, Integer timeout, String rcLog, List<SeleniumBrowser> browsers, String display) {
        super(display);
        this.port = port;
        this.rcBrowserSideLog = rcBrowserSideLog;
        this.rcDebug = rcDebug;
        this.rcTrustAllSSLCerts = rcTrustAllSSLCerts;
        this.rcBrowserSessionReuse = rcBrowserSessionReuse;
        this.rcLog = rcLog;
        this.timeout = timeout;
        this.browsers = browsers;
    }

    @Exported
    public String getRcLog() {
        return this.rcLog;
    }

    @Exported
    public boolean getRcBrowserSideLog() {
        return this.rcBrowserSideLog;
    }

    @Exported
    public boolean getRcDebug() {
        return this.rcDebug;
    }

    @Exported
    public boolean getRcTrustAllSSLCerts() {
        return this.rcTrustAllSSLCerts;
    }

    @Exported
    public boolean getRcBrowserSessionReuse() {
        return this.rcBrowserSessionReuse;
    }

    @Exported
    public int getPort() {
        return this.port;
    }

    @Exported
    public Integer getTimeout() {
        return this.timeout;
    }

    @Exported
    public List<SeleniumBrowser> getBrowsers() {
        return this.browsers;
    }

    @Override
    public SeleniumRunOptions initOptions(Computer c) {
        SeleniumRunOptions opt = super.initOptions(c);
        opt.addOptionIfSet("-log", this.getRcLog());
        try {
            opt.addOptionIfSet("-port", c.getChannel().call((Callable)new RetrieveAvailablePort(this.getPort())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getRcBrowserSideLog()) {
            opt.addOption("-browserSideLog");
        }
        if (this.getRcDebug()) {
            opt.addOption("-debug");
        }
        if (this.getRcTrustAllSSLCerts()) {
            opt.addOption("-trustAllSSLCertificates");
        }
        if (this.getRcBrowserSessionReuse()) {
            opt.addOption("-browserSessionReuse");
        }
        if (this.getTimeout() != null && this.getTimeout() > -1) {
            opt.addOption("-timeout");
            opt.addOption(this.getTimeout().toString());
        }
        for (SeleniumBrowser b : this.browsers) {
            b.initOptions(c, opt);
        }
        return opt;
    }

    @Override
    public String getIcon() {
        return "/plugin/selenium/24x24/internet-web-browser.png";
    }

    @Extension
    public static class DescriptorImpl
    extends ConfigurationDescriptor {
        public String getDisplayName() {
            return "Custom RC node configuration";
        }

        public CustomRCConfiguration getDefault() {
            return new CustomRCConfiguration();
        }

        public static List<Descriptor<SeleniumBrowser>> getBrowserTypes() {
            ArrayList<Descriptor<SeleniumBrowser>> lst = new ArrayList<Descriptor<SeleniumBrowser>>();
            for (SeleniumBrowser.SeleniumBrowserDescriptor b : SeleniumBrowser.all()) {
                lst.add(b);
            }
            return lst;
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            try {
                Integer i = Integer.parseInt(value);
                if (i >= -1) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Must be an integer greater than or equal to -1.");
        }
    }
}

