/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.callables;

import hudson.remoting.ChannelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class PropertyUtils {
    private static Map<String, Object> properties = new ConcurrentHashMap<String, Object>();

    private PropertyUtils() {
    }

    public static <T> T getProperty(ChannelProperty<T> property) {
        return property.type.cast(properties.get(property.displayName));
    }

    public static void setProperty(ChannelProperty<?> property, Object object) {
        properties.put(property.displayName, object);
    }

    public static <T> T getMapProperty(ChannelProperty<?> property, String key) {
        ChannelProperty cp = new ChannelProperty(Map.class, property.displayName);
        Map map = (Map)PropertyUtils.getProperty(cp);
        if (map == null) {
            return null;
        }
        return (T)map.get(key);
    }

    public static void setMapProperty(ChannelProperty<?> property, String key, Object object) {
        ChannelProperty cp = new ChannelProperty(Map.class, property.displayName);
        HashMap<String, Object> map = (HashMap<String, Object>)PropertyUtils.getProperty(cp);
        if (map == null) {
            map = new HashMap<String, Object>();
            PropertyUtils.setProperty(cp, map);
        }
        map.put(key, object);
        PropertyUtils.setProperty(cp, map);
    }
}

