/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Plugin;
import hudson.console.HyperlinkNote;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Label;
import hudson.model.TaskListener;
import hudson.plugins.selenium.HubHolder;
import hudson.plugins.selenium.HubLauncher;
import hudson.plugins.selenium.HubParams;
import hudson.plugins.selenium.HubParamsCallable;
import hudson.plugins.selenium.Messages;
import hudson.plugins.selenium.SeleniumTestSlot;
import hudson.plugins.selenium.SeleniumTestSlotGroup;
import hudson.plugins.selenium.callables.hub.StopHubCallable;
import hudson.plugins.selenium.configuration.ConfigurationDescriptor;
import hudson.plugins.selenium.configuration.CustomRCConfiguration;
import hudson.plugins.selenium.configuration.CustomWDConfiguration;
import hudson.plugins.selenium.configuration.SeleniumNodeConfiguration;
import hudson.plugins.selenium.configuration.browser.selenium.IEBrowser;
import hudson.plugins.selenium.configuration.browser.selenium.SeleniumBrowser;
import hudson.plugins.selenium.configuration.browser.webdriver.ChromeBrowser;
import hudson.plugins.selenium.configuration.browser.webdriver.FirefoxBrowser;
import hudson.plugins.selenium.configuration.browser.webdriver.WebDriverBrowser;
import hudson.plugins.selenium.configuration.global.SeleniumGlobalConfiguration;
import hudson.plugins.selenium.configuration.global.hostname.HostnameResolver;
import hudson.plugins.selenium.configuration.global.hostname.HostnameResolverDescriptor;
import hudson.plugins.selenium.configuration.global.hostname.JenkinsRootHostnameResolver;
import hudson.plugins.selenium.configuration.global.matcher.MatchAllMatcher;
import hudson.plugins.selenium.configuration.global.matcher.SeleniumConfigurationMatcher;
import hudson.plugins.selenium.process.SeleniumProcessUtils;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.framework.io.LargeText;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSlot;
import org.springframework.util.StringUtils;

@ExportedBean
public class PluginImpl
extends Plugin
implements Action,
Serializable,
Describable<PluginImpl> {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = ",";
    private static final Logger LOGGER = Logger.getLogger(PluginImpl.class.getName());
    private static final PermissionGroup SELENIUM_GROUP = new PermissionGroup(PluginImpl.class, Messages._PermissionGroup());
    private static final Permission SELENIUM_ADMIN = new Permission(SELENIUM_GROUP, "Admin", Messages._AdminPermission(), Computer.CONFIGURE, true, new PermissionScope[0]);
    private int port = 4444;
    private String exclusionPatterns;
    private Integer newSessionWaitTimeout = -1;
    private Integer maxSession = 5;
    private Integer timeout = 300;
    private Integer browserTimeout = 0;
    private boolean throwOnCapabilityNotPresent = false;
    private String hubLogLevel = "INFO";
    private HostnameResolver hostnameResolver = new JenkinsRootHostnameResolver();
    private final List<SeleniumGlobalConfiguration> configurations = new ArrayList<SeleniumGlobalConfiguration>();
    private transient Channel channel;
    private transient Future<?> hubLauncher;
    private transient StreamTaskListener listener;
    private transient String rcFirefoxProfileTemplate;
    private transient Boolean rcBrowserSessionReuse;
    private transient Boolean rcTrustAllSSLCerts;
    private transient Boolean rcBrowserSideLog;
    private transient boolean rcDebug;

    public void postInitialize() throws Exception {
        this.startHub();
        Jenkins.getInstance().getActions().add(this);
    }

    public void start() throws Exception {
        this.load();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        super.configure(req, formData);
        this.port = formData.optInt("port", 4444);
        this.exclusionPatterns = formData.getString("exclusionPatterns");
        this.hubLogLevel = formData.getString("hubLogLevel");
        this.newSessionWaitTimeout = formData.optInt("newSessionWaitTimeout", -1);
        this.maxSession = formData.optInt("maxSession", 5);
        this.timeout = formData.optInt("timeout", 300000);
        this.browserTimeout = formData.optInt("browserTimeout", 0);
        this.throwOnCapabilityNotPresent = formData.getBoolean("throwOnCapabilityNotPresent");
        this.hostnameResolver = (HostnameResolver)req.bindJSON(HostnameResolver.class, formData.optJSONObject("hostnameResolver"));
        if (this.hostnameResolver == null) {
            this.hostnameResolver = new JenkinsRootHostnameResolver();
        }
        this.save();
    }

    private void startHub() throws IOException, InterruptedException {
        this.listener = new StreamTaskListener(this.getLogFile());
        this.channel = SeleniumProcessUtils.createSeleniumGridVM((TaskListener)this.listener);
        Level logLevel = Level.parse(this.getHubLogLevel());
        this.listener.getLogger().println("Starting Selenium Grid");
        ArrayList<String> args = new ArrayList<String>();
        if (this.getNewSessionWaitTimeout() != null && this.getNewSessionWaitTimeout() >= 0) {
            args.add("-newSessionWaitTimeout");
            args.add(this.getNewSessionWaitTimeout().toString());
        }
        if (this.getMaxSession() != null && this.getMaxSession() > 0) {
            args.add("-maxSession");
            args.add(this.getMaxSession().toString());
        }
        if (this.getTimeout() != null) {
            args.add("-timeout");
            args.add(this.getTimeout().toString());
        }
        if (this.getBrowserTimeout() != null) {
            args.add("-browserTimeout");
            args.add(this.getBrowserTimeout().toString());
        }
        if (this.getThrowOnCapabilityNotPresent()) {
            args.add("-throwOnCapabilityNotPresent");
            args.add(Boolean.toString(this.getThrowOnCapabilityNotPresent()));
        }
        args.add("-host");
        args.add(PluginImpl.getMasterHostName());
        this.hubLauncher = this.channel.callAsync((Callable)new HubLauncher(this.port, args.toArray(new String[args.size()]), logLevel));
    }

    public File getLogFile() {
        return new File(Jenkins.getInstance().getRootDir(), "selenium.log");
    }

    public void waitForHubLaunch() throws ExecutionException, InterruptedException {
        this.hubLauncher.get();
    }

    public String getDisplayName() {
        return "Selenium Grid";
    }

    public String getIconFileName() {
        return "/plugin/selenium/24x24/selenium.png";
    }

    public String getUrlName() {
        return "/selenium";
    }

    @Exported
    public int getPort() {
        return this.port;
    }

    @Exported
    public HostnameResolver getHostnameResolver() {
        return this.hostnameResolver;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    @Exported
    public String getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    @Exported
    public Integer getNewSessionWaitTimeout() {
        return this.newSessionWaitTimeout;
    }

    @Exported
    public Integer getMaxSession() {
        return this.maxSession;
    }

    @Exported
    public Integer getTimeout() {
        return this.timeout;
    }

    @Exported
    public Integer getBrowserTimeout() {
        return this.browserTimeout;
    }

    @Exported
    public String getHubLogLevel() {
        return this.hubLogLevel != null ? this.hubLogLevel : "INFO";
    }

    @Exported
    public boolean getConfigurationChanged() {
        HubParams activeHubParams = this.getCurrentHubParams();
        return activeHubParams.isNotActiveOn(PluginImpl.getMasterHostName(), this.port);
    }

    @Exported
    public Integer getActivePort() {
        return this.getCurrentHubParams().getPort();
    }

    @Exported
    public String getActiveHost() {
        return this.getCurrentHubParams().getHost();
    }

    public HubParams getCurrentHubParams() {
        HubParams result = new HubParams();
        if (this.channel == null) {
            return result;
        }
        try {
            return (HubParams)this.channel.call((Callable)new HubParamsCallable());
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Unable to communicate with hub", e);
            return result;
        }
    }

    @Exported
    public boolean getThrowOnCapabilityNotPresent() {
        return this.throwOnCapabilityNotPresent;
    }

    public void stop() throws Exception {
        for (Computer c : Jenkins.getInstance().getComputers()) {
            for (SeleniumGlobalConfiguration cfg : this.configurations) {
                cfg.stop(c);
            }
        }
        this.listener.closeQuietly();
        this.channel.close();
    }

    @Exported(inline=true)
    public Collection<SeleniumTestSlotGroup> getRemoteControls() throws IOException, InterruptedException {
        if (this.channel == null) {
            return Collections.emptyList();
        }
        return (Collection)this.channel.call((Callable)new MasterToSlaveCallable<Collection<SeleniumTestSlotGroup>, RuntimeException>(){
            private static final long serialVersionUID = 1791985298575049757L;

            public Collection<SeleniumTestSlotGroup> call() {
                HashMap<URL, SeleniumTestSlotGroup> groups = new HashMap<URL, SeleniumTestSlotGroup>();
                if (HubHolder.getHub() == null) {
                    return Collections.emptyList();
                }
                GridRegistry registry = HubHolder.getHub().getRegistry();
                if (registry != null) {
                    for (RemoteProxy proxy : registry.getAllProxies()) {
                        for (TestSlot slot : proxy.getTestSlots()) {
                            URL host = slot.getProxy().getRemoteHost();
                            SeleniumTestSlotGroup grp = (SeleniumTestSlotGroup)groups.get(host);
                            if (grp == null) {
                                grp = new SeleniumTestSlotGroup(host);
                                groups.put(host, grp);
                            }
                            grp.addTestSlot(new SeleniumTestSlot(slot));
                        }
                    }
                }
                ArrayList<SeleniumTestSlotGroup> values = new ArrayList<SeleniumTestSlotGroup>(groups.values());
                Collections.sort(values);
                return values;
            }
        });
    }

    public static String getMasterHostName() {
        return PluginImpl.getPlugin().hostnameResolver.retrieveHost();
    }

    public void doProgressiveLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        new LargeText(this.getLogFile(), false).doProgressText(req, rsp);
    }

    public Descriptor<PluginImpl> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readResolve() {
        if (this.rcFirefoxProfileTemplate != null || this.rcBrowserSessionReuse != null || this.rcTrustAllSSLCerts != null || this.rcBrowserSideLog != null) {
            String rcFirefoxProfileTemplate = this.getDefaultForNull(this.rcFirefoxProfileTemplate, "");
            Boolean rcBrowserSessionReuse = this.getDefaultForNull(this.rcBrowserSessionReuse, Boolean.FALSE);
            Boolean rcTrustAllSSLCerts = this.getDefaultForNull(this.rcTrustAllSSLCerts, Boolean.FALSE);
            Boolean rcBrowserSideLog = this.getDefaultForNull(this.rcBrowserSideLog, Boolean.FALSE);
            ArrayList<SeleniumBrowser> browsers = new ArrayList<SeleniumBrowser>();
            browsers.add(new IEBrowser(5, "", "", false));
            browsers.add(new hudson.plugins.selenium.configuration.browser.selenium.FirefoxBrowser(5, "", ""));
            browsers.add(new hudson.plugins.selenium.configuration.browser.selenium.ChromeBrowser(5, "", ""));
            int port = 4445;
            try {
                ServerSocket ss = new ServerSocket(0);
                port = ss.getLocalPort();
                ss.close();
            }
            catch (IOException ss) {
                // empty catch block
            }
            CustomRCConfiguration c = new CustomRCConfiguration(port, rcBrowserSideLog, this.rcDebug, rcTrustAllSSLCerts, rcBrowserSessionReuse, -1, rcFirefoxProfileTemplate, browsers, null);
            List<SeleniumGlobalConfiguration> list = this.configurations;
            synchronized (list) {
                this.configurations.add(new SeleniumGlobalConfiguration("Selenium v2.0 configuration", new MatchAllMatcher(), c));
            }
        }
        if (this.hostnameResolver == null) {
            this.hostnameResolver = new JenkinsRootHostnameResolver();
        }
        return this;
    }

    private <T> T getDefaultForNull(T object, T defaultObject) {
        return object == null ? defaultObject : object;
    }

    public static void startSeleniumNode(Computer c, TaskListener listener, String conf) throws IOException, InterruptedException {
        String masterName;
        LOGGER.fine("Examining if we need to start Selenium Grid Node");
        PluginImpl p = (PluginImpl)Jenkins.getInstance().getPlugin(PluginImpl.class);
        String exclusions = p.getExclusionPatterns();
        List<Object> exclusionPatterns = new ArrayList();
        if (StringUtils.hasText((String)exclusions)) {
            exclusionPatterns = Arrays.asList(exclusions.split(SEPARATOR));
        }
        if (exclusionPatterns.size() > 0) {
            for (Label label : c.getNode().getAssignedLabels()) {
                for (String string : exclusionPatterns) {
                    if (!label.toString().matches(string)) continue;
                    LOGGER.fine("Node " + c.getNode().getDisplayName() + " is excluded from Selenium Grid because its label '" + label + "' matches exclusion pattern '" + string + "'");
                    return;
                }
            }
        }
        if ((masterName = PluginImpl.getMasterHostName()) == null) {
            listener.getLogger().println("Unable to determine the host name of the master. Skipping Selenium execution. Please " + HyperlinkNote.encodeTo((String)"/configure", (String)"configure the Jenkins URL") + " from the system configuration screen.");
            return;
        }
        try {
            p.waitForHubLaunch();
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to wait for the Hub launch to complete", e);
        }
        List<SeleniumGlobalConfiguration> confs = PluginImpl.getPlugin().getGlobalConfigurationForComputer(c);
        if (confs == null || confs.size() == 0) {
            LOGGER.fine("There is no matching configurations for that computer. Skipping selenium execution.");
            return;
        }
        listener.getLogger().println("Starting Selenium nodes on " + ("".equals(c.getName()) ? "(master)" : c.getName()));
        for (SeleniumGlobalConfiguration seleniumGlobalConfiguration : confs) {
            if ((conf == null || !seleniumGlobalConfiguration.getName().equals(conf)) && conf != null) continue;
            try {
                seleniumGlobalConfiguration.start(c, listener);
            }
            catch (ExecutionException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public static PluginImpl getPlugin() {
        return (PluginImpl)Jenkins.getInstance().getPlugin(PluginImpl.class);
    }

    @Exported
    public List<SeleniumGlobalConfiguration> getGlobalConfigurations() {
        return this.configurations;
    }

    public boolean hasGlobalConfiguration(String name) {
        return this.getConfiguration(name) != null;
    }

    public void removeGlobalConfigurations(String name) throws IOException {
        this.removeGlobalConfigurations(name, true);
    }

    public List<SeleniumGlobalConfiguration> getGlobalConfigurationForComputer(Computer computer) {
        ArrayList<SeleniumGlobalConfiguration> confs = new ArrayList<SeleniumGlobalConfiguration>();
        for (SeleniumGlobalConfiguration c : PluginImpl.getPlugin().getGlobalConfigurations()) {
            if (!c.getMatcher().match(computer.getNode())) continue;
            confs.add(c);
        }
        return confs;
    }

    public SeleniumGlobalConfiguration getConfiguration(String name) {
        this.validateAdmin();
        for (SeleniumGlobalConfiguration c : this.configurations) {
            if (!name.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    public void doAddRedirect(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.validateAdmin();
        rsp.sendRedirect2("add");
    }

    public void validateAdmin() {
        Jenkins.getInstance().checkPermission(this.getRequiredPermission());
    }

    public boolean isAdmin() {
        return Jenkins.getInstance().hasPermission(this.getRequiredPermission());
    }

    public void doCreate(StaplerRequest req, StaplerResponse rsp) throws Exception {
        this.validateAdmin();
        SeleniumGlobalConfiguration conf = (SeleniumGlobalConfiguration)req.bindJSON(SeleniumGlobalConfiguration.class, req.getSubmittedForm());
        if (null == conf.getName() || conf.getName().trim().equals("")) {
            throw new Failure("You must specify a name for the configuration");
        }
        if (PluginImpl.getPlugin().hasGlobalConfiguration(conf.getName())) {
            throw new Failure("The configuration name you have chosen is already taken, please choose a unique name.");
        }
        PluginImpl.getPlugin().getGlobalConfigurations().add(conf);
        PluginImpl.getPlugin().save();
        rsp.sendRedirect2("configurations");
    }

    public Permission getRequiredPermission() {
        return SELENIUM_ADMIN;
    }

    public DescriptorExtensionList<SeleniumNodeConfiguration, ConfigurationDescriptor> getConfigTypes() {
        return SeleniumNodeConfiguration.all();
    }

    public DescriptorExtensionList<SeleniumConfigurationMatcher, SeleniumConfigurationMatcher.MatcherDescriptor> getMatcherTypes() {
        return SeleniumConfigurationMatcher.all();
    }

    public DescriptorExtensionList<HostnameResolver, HostnameResolverDescriptor> getResolverTypes() {
        return HostnameResolver.all();
    }

    public Map<Computer, List<SeleniumGlobalConfiguration>> getComputers() {
        TreeMap<Computer, List<SeleniumGlobalConfiguration>> cps = new TreeMap<Computer, List<SeleniumGlobalConfiguration>>(new Comparator<Computer>(){

            @Override
            public int compare(Computer o1, Computer o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Computer c : Jenkins.getInstance().getComputers()) {
            List<SeleniumGlobalConfiguration> confs = this.getGlobalConfigurationForComputer(c);
            if (confs == null || confs.size() <= 0) continue;
            cps.put(c, confs);
        }
        return cps;
    }

    public Channel getHubChannel() {
        return this.channel;
    }

    public SeleniumConfigurationMatcher getDefaultMatcher() {
        return new MatchAllMatcher();
    }

    public SeleniumNodeConfiguration getDefaultConfiguration() {
        this.validateAdmin();
        ArrayList<WebDriverBrowser> browsers = new ArrayList<WebDriverBrowser>();
        browsers.add(new hudson.plugins.selenium.configuration.browser.webdriver.IEBrowser(1, null, null, false));
        browsers.add(new FirefoxBrowser(5, null, null));
        browsers.add(new ChromeBrowser(5, null, null));
        return new CustomWDConfiguration(4445, null, browsers, null, 5);
    }

    public void replaceGlobalConfigurations(String name, SeleniumGlobalConfiguration conf) throws IOException {
        this.validateAdmin();
        this.removeGlobalConfigurations(name, false);
        this.configurations.add(conf);
        PluginImpl.getPlugin().save();
    }

    private void removeGlobalConfigurations(String name, boolean save) throws IOException {
        Iterator<SeleniumGlobalConfiguration> it = this.configurations.iterator();
        while (it.hasNext()) {
            SeleniumGlobalConfiguration conf = it.next();
            if (!conf.getName().equals(name)) continue;
            it.remove();
            for (Computer c : Jenkins.getInstance().getComputers()) {
                conf.remove(c);
            }
            if (save) {
                this.save();
            }
            return;
        }
    }

    public HttpResponse doRestart() throws IOException {
        this.validateAdmin();
        try {
            this.channel.call((Callable)new StopHubCallable());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.channel.close();
        try {
            this.startHub();
            this.waitForHubLaunch();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return HttpResponses.forwardToPreviousPage();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<PluginImpl> {
        public String getDisplayName() {
            return "";
        }
    }
}

