/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import java.io.Serializable;
import java.net.URL;

public class HubParams
implements Serializable {
    private static final long serialVersionUID = 3813168118997469056L;
    private String host = "";
    private Integer port = -1;
    private boolean isActive = false;

    public HubParams() {
        this("", -1, false);
    }

    public HubParams(URL host, boolean isActive) {
        this.host = host.getHost();
        this.port = host.getPort();
        this.isActive = isActive;
    }

    public HubParams(String host, Integer port, boolean isActive) {
        this.host = host;
        this.port = port;
        this.isActive = isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isNotActiveOn(String masterHostName, int masterPort) {
        return this.isActive && (this.port != masterPort || !this.host.equalsIgnoreCase(masterHostName));
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }
}

