/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.collections.map.LRUMap;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.config.Parameter;

public class GroovyScript
extends MasterToSlaveCallable<Object, RuntimeException> {
    private static final long serialVersionUID = 1L;
    private final String script;
    @NonNull
    private final Collection<Parameter> parameters;
    private final boolean failWithException;
    private final TaskListener listener;
    private static final Map<String, ConcurrentLinkedQueue<Script>> cache = Collections.synchronizedMap(new LRUMap(10));
    private static final Set<String> DEFAULT_VARIABLES = new HashSet<String>();

    public GroovyScript(String script, @NonNull Collection<Parameter> parameters, boolean failWithException, TaskListener listener) {
        this.script = script;
        this.parameters = new ArrayList<Parameter>(parameters);
        this.failWithException = failWithException;
        this.listener = listener;
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() {
        String string;
        block13: {
            Script parsedScript;
            ConcurrentLinkedQueue<Object> scriptPool;
            PrintStream logger;
            block11: {
                Object object;
                block12: {
                    logger = this.listener.getLogger();
                    GroovyShell shell = new GroovyShell(this.getClassLoader());
                    for (Parameter param : this.parameters) {
                        String paramName = param.getName();
                        if (DEFAULT_VARIABLES.contains(paramName)) {
                            logger.println(Messages.skipParameter(paramName));
                            continue;
                        }
                        shell.setVariable(paramName, (Object)param.getValue());
                    }
                    shell.setVariable("out", (Object)logger);
                    this.setShellVariables(shell);
                    scriptPool = cache.get(this.script);
                    if (scriptPool == null) {
                        scriptPool = new ConcurrentLinkedQueue();
                        cache.put(this.script, scriptPool);
                        scriptPool = cache.get(this.script);
                    }
                    parsedScript = scriptPool.poll();
                    if (parsedScript == null) {
                        parsedScript = shell.parse(this.script);
                    }
                    parsedScript.setBinding(shell.getContext());
                    Object output = parsedScript.run();
                    if (output == null) break block11;
                    logger.println(Messages.resultPrefix() + " " + String.valueOf(output));
                    object = output;
                    if (parsedScript == null) break block12;
                    scriptPool.add(parsedScript);
                }
                return object;
            }
            try {
                string = "";
                if (parsedScript == null) break block13;
                scriptPool.add(parsedScript);
            }
            catch (Throwable t) {
                Boolean bl;
                block14: {
                    try {
                        if (this.failWithException) {
                            throw new ScriptlerExecutionException(t);
                        }
                        t.printStackTrace(logger);
                        bl = Boolean.FALSE;
                        if (parsedScript == null) break block14;
                        scriptPool.add(parsedScript);
                    }
                    catch (Throwable throwable) {
                        if (parsedScript != null) {
                            scriptPool.add(parsedScript);
                        }
                        throw throwable;
                    }
                }
                return bl;
            }
        }
        return string;
    }

    protected void setShellVariables(@NonNull GroovyShell shell) {
        shell.setVariable("listener", (Object)this.listener);
    }

    static {
        DEFAULT_VARIABLES.add("out");
        DEFAULT_VARIABLES.add("build");
        DEFAULT_VARIABLES.add("listener");
        DEFAULT_VARIABLES.add("launcher");
    }

    private static final class ScriptlerExecutionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ScriptlerExecutionException(Throwable cause) {
            super(cause);
        }
    }
}

