/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.util.StreamTaskListener;
import jakarta.servlet.ServletException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.ScriptlerManagement;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.share.ScriptInfo;
import org.jenkinsci.plugins.scriptler.util.GroovyScript;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.UnapprovedUsageException;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;

public final class ScriptHelper {
    private static final Logger LOGGER = Logger.getLogger(ScriptHelper.class.getName());
    private static final Pattern SCRIPT_META_PATTERN = Pattern.compile(".*BEGIN META(.+?)END META.*", 32);
    private static final Map<String, Class<?>> JSON_CLASS_MAPPING = Map.of("authors", ScriptInfo.Author.class, "parameters", Parameter.class);

    private ScriptHelper() {
    }

    @NonNull
    public static String readScriptFromFile(@NonNull Path path) throws IOException {
        return Files.readString(path, StandardCharsets.UTF_8);
    }

    public static void writeScriptToFile(@NonNull Path path, @NonNull String script) throws IOException {
        Files.writeString(path, (CharSequence)script, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    @CheckForNull
    public static Script getScript(@CheckForNull String id, boolean withSrc) {
        if (id == null || id.isBlank()) {
            return null;
        }
        Script s = ScriptlerConfiguration.getConfiguration().getScriptById(id);
        if (withSrc && s != null) {
            Path scriptSrc = ScriptlerManagement.getScriptDirectory2().resolve(s.getScriptPath());
            try {
                s.setScriptText(ScriptHelper.readScriptFromFile(scriptSrc));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, Messages.scriptSourceNotFound(id));
            }
        }
        return s;
    }

    public static void putScriptInApprovalQueueIfRequired(@NonNull String scriptSourceCode) {
        ScriptApproval.get().configuring(scriptSourceCode, GroovyLanguage.get(), ApprovalContext.create().withCurrentUser(), true);
    }

    public static boolean isApproved(@CheckForNull String scriptSourceCode) {
        return ScriptHelper.isApproved(scriptSourceCode, true);
    }

    public static boolean isApproved(@CheckForNull String scriptSourceCode, boolean putInApprovalQueueIfNotApprovedYet) {
        if (scriptSourceCode == null) {
            return false;
        }
        try {
            ScriptApproval.get().using(scriptSourceCode, GroovyLanguage.get());
            return true;
        }
        catch (UnapprovedUsageException e) {
            if (putInApprovalQueueIfNotApprovedYet) {
                ScriptHelper.putScriptInApprovalQueueIfRequired(scriptSourceCode);
                try {
                    ScriptApproval.get().using(scriptSourceCode, GroovyLanguage.get());
                    return true;
                }
                catch (UnapprovedUsageException unapprovedUsageException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    @Deprecated(since="381")
    public static String runScript(String[] computers, String scriptText, @NonNull Collection<Parameter> parameters) throws IOException, ServletException {
        return ScriptHelper.runScript(Arrays.asList(computers), scriptText, parameters);
    }

    public static String runScript(List<String> computers, String scriptText, @NonNull Collection<Parameter> parameters) throws IOException, ServletException {
        StringBuilder output = new StringBuilder();
        for (String computer : computers) {
            LOGGER.log(Level.FINE, "here is the node -> {0}", computer);
            output.append("___________________________________________\n");
            output.append("[").append(computer).append("]:\n");
            output.append(ScriptHelper.runScript(computer, scriptText, parameters));
        }
        output.append("___________________________________________\n");
        return output.toString();
    }

    public static String runScript(String node, String scriptTxt, @NonNull Collection<Parameter> parameters) throws IOException, ServletException {
        ByteArrayOutputStream sos = new ByteArrayOutputStream();
        if (node != null && scriptTxt != null) {
            try {
                Computer comp = Jenkins.get().getComputer(node);
                StreamTaskListener listener = new StreamTaskListener((OutputStream)sos, StandardCharsets.UTF_8);
                if (comp == null && "(built-in)".equals(node)) {
                    FilePath.localChannel.call((Callable)new GroovyScript(scriptTxt, parameters, false, (TaskListener)listener));
                } else if (comp != null && comp.getChannel() != null) {
                    comp.getChannel().call((Callable)new GroovyScript(scriptTxt, parameters, false, (TaskListener)listener));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ServletException((Throwable)e);
            }
        }
        return sos.toString(StandardCharsets.UTF_8);
    }

    public static ScriptInfo extractScriptInfo(String fullScriptBody) {
        Matcher matcher = SCRIPT_META_PATTERN.matcher(fullScriptBody);
        if (matcher.find()) {
            String group = matcher.group(1);
            JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)group.trim());
            return (ScriptInfo)JSONObject.toBean((JSONObject)json, ScriptInfo.class, JSON_CLASS_MAPPING);
        }
        return null;
    }
}

