/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.config;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jenkinsci.plugins.scriptler.config.NamedResource;
import org.jenkinsci.plugins.scriptler.config.Parameter;

public class Script
implements Comparable<Script>,
NamedResource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    public final String name;
    public final String comment;
    public final String originCatalog;
    public final String originScript;
    public final String originDate;
    @NonNull
    private final List<Parameter> parameters;
    private boolean available;
    private transient String scriptText;
    public final boolean nonAdministerUsing;
    public final boolean onlyController;
    @Deprecated(since="381")
    public final Boolean onlyMaster;
    public static final Comparator<Script> COMPARATOR_BY_NAME = Comparator.comparing(Script::getNonNullName, String.CASE_INSENSITIVE_ORDER);

    public Script(String id, String name, String comment, boolean nonAdministerUsing, @NonNull List<Parameter> parameters, boolean onlyController) {
        this(id, name, comment, true, null, null, null, nonAdministerUsing, parameters, onlyController);
    }

    public Script(String id, String comment, boolean available, boolean nonAdministerUsing, boolean onlyController) {
        this(id, id, comment, available, null, null, null, nonAdministerUsing, Collections.emptyList(), onlyController);
    }

    public Script(String id, String name, String comment, boolean available, String originCatalog, String originScript, String originDate, @NonNull List<Parameter> parameters) {
        this(id, name, comment, available, originCatalog, originScript, originDate, false, parameters, false);
    }

    public Script(String id, String name, String comment, String originCatalog, String originScript, String originDate, boolean nonAdministerUsing, @NonNull List<Parameter> parameters, boolean onlyController) {
        this(id, name, comment, true, originCatalog, originScript, originDate, nonAdministerUsing, parameters, onlyController);
    }

    public Script(String id, String name, String comment, boolean available, String originCatalog, String originScript, String originDate, boolean nonAdministerUsing, @NonNull List<Parameter> parameters, boolean onlyController) {
        this.id = id;
        this.name = name;
        this.comment = comment;
        this.available = available;
        this.originCatalog = originCatalog;
        this.originScript = originScript;
        this.originDate = originDate;
        this.nonAdministerUsing = nonAdministerUsing;
        this.parameters = new ArrayList<Parameter>(parameters);
        this.onlyController = onlyController;
        this.onlyMaster = null;
    }

    public Script copy() {
        return new Script(this.id, this.name, this.comment, this.available, this.originCatalog, this.originScript, this.originDate, this.nonAdministerUsing, this.parameters, this.onlyController);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNonNullName() {
        return Util.fixNull((String)this.name);
    }

    public String getScriptPath() {
        return this.id;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    @CheckForNull
    public String getScriptText() {
        return this.scriptText;
    }

    @Deprecated(since="381")
    @CheckForNull
    public String getScript() {
        return this.getScriptText();
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    @Deprecated(since="381")
    public void setScript(String scriptText) {
        this.setScriptText(scriptText);
    }

    public void setParameters(@NonNull List<Parameter> parameters) {
        this.parameters.clear();
        this.parameters.addAll(parameters);
    }

    @NonNull
    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public int compareTo(Script o) {
        return this.id.compareTo(o.id);
    }

    public Object readResolve() {
        if (this.onlyMaster != null) {
            return new Script(this.id, this.name, this.comment, this.available, this.originCatalog, this.originScript, this.originDate, this.nonAdministerUsing, this.parameters, this.onlyMaster);
        }
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return "[Script: " + this.id + ":" + this.name + "]";
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Script other = (Script)obj;
        return Objects.equals(this.id, other.id);
    }
}

