/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.config;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jenkinsci.plugins.scriptler.config.NamedResource;
import org.jenkinsci.plugins.scriptler.config.Parameter;

public class Script
implements Comparable<Script>,
NamedResource {
    private final String id;
    public final String name;
    public final String comment;
    public final String originCatalog;
    public final String originScript;
    public final String originDate;
    @NonNull
    private final List<Parameter> parameters;
    public boolean available = true;
    public transient String script;
    public final boolean nonAdministerUsing;
    public final boolean onlyMaster;
    public static final Comparator<Script> COMPARATOR_BY_NAME = (a, b) -> {
        String nameA = a.getName() != null ? a.getName() : "";
        String nameB = b.getName() != null ? b.getName() : "";
        return nameA.compareToIgnoreCase(nameB);
    };

    public Script(String id, String name, String comment, boolean nonAdministerUsing, @NonNull List<Parameter> parameters, boolean onlyMaster) {
        this(id, name, comment, true, null, null, null, nonAdministerUsing, parameters, onlyMaster);
    }

    public Script(String id, String comment, boolean available, boolean nonAdministerUsing, boolean onlyMaster) {
        this(id, id, comment, available, null, null, null, nonAdministerUsing, Collections.emptyList(), onlyMaster);
    }

    public Script(String id, String name, String comment, boolean available, String originCatalog, String originScript, String originDate, @NonNull List<Parameter> parameters) {
        this(id, name, comment, available, originCatalog, originScript, originDate, false, parameters, false);
    }

    public Script(String id, String name, String comment, String originCatalog, String originScript, String originDate, boolean nonAdministerUsing, @NonNull List<Parameter> parameters, boolean onlyMaster) {
        this(id, name, comment, true, originCatalog, originScript, originDate, nonAdministerUsing, parameters, onlyMaster);
    }

    public Script(String id, String name, String comment, boolean available, String originCatalog, String originScript, String originDate, boolean nonAdministerUsing, @NonNull List<Parameter> parameters, boolean onlyMaster) {
        this.id = id;
        this.name = name;
        this.comment = comment;
        this.available = available;
        this.originCatalog = originCatalog;
        this.originScript = originScript;
        this.originDate = originDate;
        this.nonAdministerUsing = nonAdministerUsing;
        this.parameters = new ArrayList<Parameter>(parameters);
        this.onlyMaster = onlyMaster;
    }

    public Script copy() {
        return new Script(this.id, this.name, this.comment, this.available, this.originCatalog, this.originScript, this.originDate, this.nonAdministerUsing, this.parameters, this.onlyMaster);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getScriptPath() {
        return this.id;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setParameters(@NonNull List<Parameter> parameters) {
        this.parameters.clear();
        this.parameters.addAll(parameters);
    }

    @NonNull
    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public int compareTo(Script o) {
        return this.id.compareTo(o.id);
    }

    public Object readResolve() {
        if (this.id == null) {
            return new Script(this.name, this.name, this.comment, this.available, this.originCatalog, this.originScript, this.originDate, this.nonAdministerUsing, this.parameters, this.onlyMaster);
        }
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return "[Script: " + this.id + ":" + this.name + "]";
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Script other = (Script)obj;
        return Objects.equals(this.id, other.id);
    }
}

