/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.share.gh;

import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.scriptler.share.CatalogInfo;
import org.jenkinsci.plugins.scriptler.share.ScriptInfo;
import org.jenkinsci.plugins.scriptler.share.ScriptInfoCatalog;
import org.jenkinsci.plugins.scriptler.share.gh.CentralScriptJsonCatalog;

@Extension(ordinal=10.0)
public class GHCatalog
extends ScriptInfoCatalog<ScriptInfo> {
    private static final Logger LOGGER = Logger.getLogger(GHCatalog.class.getName());
    public static final String REPO_BASE = "https://github.com/jenkinsci/jenkins-scripts/tree/master/scriptler";
    public static final String DOWNLOAD_URL = "https://raw.github.com/jenkinsci/jenkins-scripts/master/scriptler/{1}";
    public static final CatalogInfo CATALOG_INFO = new CatalogInfo("gh", "https://github.com/jenkinsci/jenkins-scripts/tree/master/scriptler", "https://github.com/jenkinsci/jenkins-scripts/tree/master/scriptler", "https://raw.github.com/jenkinsci/jenkins-scripts/master/scriptler/{1}");

    @Override
    public List<ScriptInfo> getEntries() {
        return this.getEntries(ScriptInfo.COMPARATOR_BY_NAME);
    }

    @Override
    public String getDisplayName() {
        return "GitHub";
    }

    @Override
    public ScriptInfo getEntryById(String id) {
        for (ScriptInfo info : this.getEntries(null)) {
            if (!id.equals(info.getId())) continue;
            return info;
        }
        return null;
    }

    private List<ScriptInfo> getEntries(@CheckForNull Comparator<ScriptInfo> comparator) {
        ScriptInfo[] scriptInfoArray = new ScriptInfo[]{};
        try {
            scriptInfoArray = CentralScriptJsonCatalog.getCatalog().toList().list;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "not abe to load script infos from GH", e);
        }
        List<ScriptInfo> sortedScriptInfoList = Arrays.asList(scriptInfoArray);
        if (comparator != null) {
            Collections.sort(sortedScriptInfoList, comparator);
        }
        return sortedScriptInfoList;
    }

    @Override
    public CatalogInfo getInfo() {
        return CATALOG_INFO;
    }

    @Override
    public String getScriptSource(ScriptInfo scriptInfo) {
        try {
            String scriptUrl = CATALOG_INFO.getReplacedDownloadUrl(scriptInfo.getName(), scriptInfo.getId());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Util.copyStreamAndClose((InputStream)ProxyConfiguration.open((URL)new URL(scriptUrl)).getInputStream(), (OutputStream)out);
            return out.toString("UTF-8");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "not abe to load script sources from GH for: " + scriptInfo, e);
            return null;
        }
    }
}

