/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.tokenmacro;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.util.GroovyScript;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ScriptlerTokenMacro
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter
    public String scriptId;

    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        Script script = ScriptHelper.getScript(this.scriptId, true);
        if (script == null) {
            throw new MacroEvaluationException(Messages.tokenmacro_ScriptDoesNotExist(this.scriptId));
        }
        if (!script.nonAdministerUsing) {
            listener.getLogger().println(Messages.tokenmacro_AdminScriptOnly(this.scriptId));
            throw new MacroEvaluationException(Messages.tokenmacro_AdminScriptOnly(this.scriptId));
        }
        Object channel = script.onlyMaster ? Jenkins.MasterComputer.localChannel : context.getWorkspace().getChannel();
        Object output = channel.call((Callable)new GroovyScript(script.script, null, true, listener, null, context));
        return output != null ? output.toString() : "";
    }

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals("SCRIPTLER");
    }
}

