/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler;

import hudson.Extension;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.model.ComputerSet;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.model.RootAction;
import hudson.security.Permission;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.ScritplerPluginImpl;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.git.GitScriptlerRepository;
import org.jenkinsci.plugins.scriptler.share.CatalogInfo;
import org.jenkinsci.plugins.scriptler.share.ScriptInfo;
import org.jenkinsci.plugins.scriptler.share.ScriptInfoCatalog;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;
import org.jenkinsci.plugins.scriptler.util.UIHelper;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ScriptlerManagment
extends ManagementLink
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(ScriptlerManagment.class.getName());
    private static final String MASTER = "(master)";
    private static final String ALL = "(all)";
    private static final String ALL_SLAVES = "(all slaves)";

    private boolean isRunScriptPermissionEnabled() {
        return this.getConfiguration().isAllowRunScriptPermission();
    }

    public Permission getRequiredPermissionForRunScript() {
        return this.isRunScriptPermissionEnabled() ? Jenkins.RUN_SCRIPTS : Jenkins.ADMINISTER;
    }

    public String getIconFileName() {
        return Jenkins.getInstance().hasPermission(this.getRequiredPermissionForRunScript()) ? "notepad.gif" : null;
    }

    public String getUrlName() {
        return "scriptler";
    }

    public boolean disableRemoteCatalog() {
        return this.getConfiguration().isDisbableRemoteCatalog();
    }

    public boolean allowRunScriptEdit() {
        return this.getConfiguration().isAllowRunScriptEdit();
    }

    public boolean allowRunScriptPermission() {
        return this.getConfiguration().isAllowRunScriptPermission();
    }

    public String getDisplayName() {
        return Messages.display_name();
    }

    public String getDescription() {
        return Messages.description();
    }

    public ScriptlerManagment getScriptler() {
        return this;
    }

    public ScriptlerConfiguration getConfiguration() {
        return ScriptlerConfiguration.getConfiguration();
    }

    public String getPluginResourcePath() {
        PluginWrapper wrapper = Hudson.getInstance().getPluginManager().getPlugin(ScritplerPluginImpl.class);
        return Hudson.getInstance().getRootUrl() + "plugin/" + wrapper.getShortName() + "/";
    }

    public HttpResponse doScriptlerSettings(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="disableRemoteCatalog") boolean disableRemoteCatalog, @QueryParameter(value="allowRunScriptPermission") boolean allowRunScriptPermission, @QueryParameter(value="allowRunScriptEdit") boolean allowRunScriptEdit) throws IOException {
        this.checkPermission(Hudson.ADMINISTER);
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.setDisbableRemoteCatalog(disableRemoteCatalog);
        cfg.setAllowRunScriptEdit(allowRunScriptEdit);
        cfg.setAllowRunScriptPermission(allowRunScriptPermission);
        cfg.save();
        return new HttpRedirect("settings");
    }

    public HttpResponse doDownloadScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id, @QueryParameter(value="catalog") String catalogName) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        ScriptlerConfiguration c = this.getConfiguration();
        if (c.isDisbableRemoteCatalog()) {
            return new HttpRedirect("index");
        }
        for (ScriptInfoCatalog scriptInfoCatalog : ScriptInfoCatalog.all()) {
            if (!catalogName.equals(scriptInfoCatalog.getInfo().name)) continue;
            Object info = scriptInfoCatalog.getEntryById(id);
            String source = scriptInfoCatalog.getScriptSource(info);
            ArrayList<Parameter> paramList = new ArrayList<Parameter>();
            for (String paramName : ((ScriptInfo)info).getParameters()) {
                paramList.add(new Parameter(paramName, null));
            }
            Parameter[] parameters = paramList.toArray(new Parameter[paramList.size()]);
            String finalName = this.saveScriptAndForward(id, ((ScriptInfo)info).getName(), ((ScriptInfo)info).getComment(), source, false, false, catalogName, id, parameters);
            return new HttpRedirect("editScript?id=" + finalName);
        }
        ForwardToView view = new ForwardToView((Object)this, "catalog.jelly");
        view.with("message", (Object)Messages.download_failed(id, catalogName));
        view.with("catName", (Object)catalogName);
        return view;
    }

    public HttpResponse doScriptAdd(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id, @QueryParameter(value="name") String name, @QueryParameter(value="comment") String comment, @QueryParameter(value="script") String script, @QueryParameter(value="nonAdministerUsing") boolean nonAdministerUsing, @QueryParameter(value="onlyMaster") boolean onlyMaster, String originCatalogName, String originId) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        Parameter[] parameters = UIHelper.extractParameters(req.getSubmittedForm());
        this.saveScriptAndForward(id, name, comment, script, nonAdministerUsing, onlyMaster, originCatalogName, originId, parameters);
        return new HttpRedirect("index");
    }

    private String saveScriptAndForward(String id, String name, String comment, String script, boolean nonAdministerUsing, boolean onlyMaster, String originCatalogName, String originId, Parameter[] parameters) throws IOException {
        String string = script = script == null ? "TODO" : script;
        if (StringUtils.isEmpty((String)id)) {
            throw new IllegalArgumentException("'id' must not be empty!");
        }
        String displayName = name == null ? id : name;
        String finalFileName = this.fixFileName(originCatalogName, id);
        File newScriptFile = new File(ScriptlerManagment.getScriptDirectory(), finalFileName);
        FileWriter writer = new FileWriter(newScriptFile);
        writer.write(script);
        ((Writer)writer).close();
        this.commitFileToGitRepo(finalFileName);
        Script newScript = null;
        newScript = !StringUtils.isEmpty((String)originId) ? new Script(finalFileName, displayName, comment, true, originCatalogName, originId, new SimpleDateFormat("dd MMM yyyy HH:mm:ss a").format(new Date()), parameters) : new Script(finalFileName, displayName, comment, nonAdministerUsing, parameters, onlyMaster);
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.addOrReplace(newScript);
        cfg.save();
        return finalFileName;
    }

    private void commitFileToGitRepo(String finalFileName) throws IOException {
        try {
            this.getGitRepo().addSingleFileToRepo(finalFileName);
        }
        catch (Exception e) {
            throw new IOException("failed to update git repo", e);
        }
    }

    private GitScriptlerRepository getGitRepo() {
        return (GitScriptlerRepository)((Object)Jenkins.getInstance().getExtensionList(GitScriptlerRepository.class).get(GitScriptlerRepository.class));
    }

    public HttpResponse doHardResetGit() throws IOException {
        this.checkPermission(Hudson.ADMINISTER);
        this.getGitRepo().hardReset();
        return new HttpRedirect("/scriptler.git");
    }

    public HttpResponse doRemoveScript(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException {
        this.checkPermission(Hudson.ADMINISTER);
        File oldScript = new File(ScriptlerManagment.getScriptDirectory(), id);
        oldScript.delete();
        try {
            GitScriptlerRepository gitRepo = (GitScriptlerRepository)((Object)Jenkins.getInstance().getExtensionList(GitScriptlerRepository.class).get(GitScriptlerRepository.class));
            gitRepo.rmSingleFileToRepo(id);
        }
        catch (Exception e) {
            throw new IOException("failed to update git repo", e);
        }
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.removeScript(id);
        cfg.save();
        return new HttpRedirect("index");
    }

    public HttpResponse doUploadScript(StaplerRequest req) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        try {
            File rootDir = ScriptlerManagment.getScriptDirectory();
            FileItem fileItem = req.getFileItem("file");
            boolean nonAdministerUsing = req.getSubmittedForm().getBoolean("nonAdministerUsing");
            String fileName = Util.getFileName((String)fileItem.getName());
            if (StringUtils.isEmpty((String)fileName)) {
                return new HttpRedirect(".");
            }
            fileName = this.fixFileName(null, fileName);
            fileItem.write(new File(rootDir, fileName));
            this.commitFileToGitRepo(fileName);
            Script script = ScriptHelper.getScript(fileName, false);
            if (script == null) {
                script = new Script(fileName, fileName, true, nonAdministerUsing, false);
            }
            ScriptlerConfiguration config = this.getConfiguration();
            config.addOrReplace(script);
            return new HttpRedirect("index");
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doRunScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException, ServletException {
        Script script = ScriptHelper.getScript(id, true);
        this.checkPermission(this.getRequiredPermissionForRunScript());
        boolean isAdmin = Jenkins.getInstance().getACL().hasPermission(Jenkins.ADMINISTER);
        boolean isChangeScriptAllowed = isAdmin || this.allowRunScriptEdit();
        req.setAttribute("script", (Object)script);
        req.setAttribute("readOnly", (Object)(!isChangeScriptAllowed ? 1 : 0));
        req.setAttribute("currentNode", (Object)MASTER);
        req.getView((Object)this, "runscript.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public void doTriggerScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id, @QueryParameter(value="script") String scriptSrc, @QueryParameter(value="node") String node) throws IOException, ServletException {
        boolean isChangeScriptAllowed;
        this.checkPermission(this.getRequiredPermissionForRunScript());
        Parameter[] parameters = UIHelper.extractParameters(req.getSubmittedForm());
        Script tempScript = null;
        boolean isAdmin = Jenkins.getInstance().getACL().hasPermission(Jenkins.ADMINISTER);
        boolean bl = isChangeScriptAllowed = isAdmin || this.allowRunScriptEdit();
        if (!isChangeScriptAllowed) {
            tempScript = ScriptHelper.getScript(id, true);
            scriptSrc = tempScript.script;
        } else {
            tempScript = ScriptHelper.getScript(id, false);
            tempScript.setScript(scriptSrc);
        }
        String[] slaves = this.resolveSlaveNames(node);
        String output = ScriptHelper.runScript(slaves, scriptSrc, parameters);
        tempScript.setParameters(parameters);
        req.setAttribute("script", (Object)tempScript);
        req.setAttribute("currentNode", (Object)node);
        req.setAttribute("output", (Object)output);
        req.setAttribute("readOnly", (Object)(!isChangeScriptAllowed ? 1 : 0));
        req.getView((Object)this, "runscript.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    private String[] resolveSlaveNames(String nameAlias) {
        List<String> slaves = null;
        if (nameAlias.equalsIgnoreCase(ALL) || nameAlias.equalsIgnoreCase(ALL_SLAVES)) {
            slaves = this.getSlaveNames();
            if (nameAlias.equalsIgnoreCase(ALL) && !slaves.contains(MASTER)) {
                slaves.add(MASTER);
            }
            if (nameAlias.equalsIgnoreCase(ALL_SLAVES)) {
                slaves.remove(MASTER);
            }
        } else {
            slaves = Arrays.asList(nameAlias);
        }
        return slaves.toArray(new String[slaves.size()]);
    }

    public void doShowScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException, ServletException {
        this.checkPermission(Hudson.RUN_SCRIPTS);
        Script script = ScriptHelper.getScript(id, true);
        req.setAttribute("script", (Object)script);
        req.getView((Object)this, "show.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public void doEditScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        Script script = ScriptHelper.getScript(id, true);
        req.setAttribute("script", (Object)script);
        req.getView((Object)this, "edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public List<String> getSlaveAlias(Script script) {
        if (script.onlyMaster) {
            ArrayList<String> slaveNames = new ArrayList<String>();
            slaveNames.add(MASTER);
            return slaveNames;
        }
        List<String> slaveNames = this.getSlaveNames();
        if (!slaveNames.contains(MASTER)) {
            slaveNames.add(0, MASTER);
        }
        if (slaveNames.size() > 0) {
            if (!slaveNames.contains(ALL)) {
                slaveNames.add(1, ALL);
            }
            if (!slaveNames.contains(ALL_SLAVES)) {
                slaveNames.add(2, ALL_SLAVES);
            }
        }
        return slaveNames;
    }

    private List<String> getSlaveNames() {
        ComputerSet computers = Jenkins.getInstance().getComputer();
        List slaveNames = computers.get_slaveNames();
        ArrayList<String> slaves = new ArrayList<String>();
        slaves.addAll(slaveNames);
        return slaves;
    }

    public List<ScriptInfoCatalog> getCatalogs() {
        return ScriptInfoCatalog.all();
    }

    public ScriptInfoCatalog<? extends ScriptInfo> getCatalogByName(String catalogName) {
        if (StringUtils.isNotBlank((String)catalogName)) {
            for (ScriptInfoCatalog sic : this.getCatalogs()) {
                CatalogInfo info = sic.getInfo();
                if (!catalogName.equals(info.name)) continue;
                return sic;
            }
        }
        return null;
    }

    public CatalogInfo getCatalogInfoByName(String catalogName) {
        if (StringUtils.isNotBlank((String)catalogName)) {
            for (ScriptInfoCatalog sic : this.getCatalogs()) {
                CatalogInfo info = sic.getInfo();
                if (!catalogName.equals(info.name)) continue;
                return info;
            }
        }
        return null;
    }

    public static File getScriptDirectory() {
        return new File(ScriptlerManagment.getScriptlerHomeDirectory(), "scripts");
    }

    public static File getScriptlerHomeDirectory() {
        return new File(Hudson.getInstance().getRootDir(), "scriptler");
    }

    private void checkPermission(Permission permission) {
        Hudson.getInstance().checkPermission(permission);
    }

    private String fixFileName(String catalogName, String name) {
        if (!name.endsWith(".groovy")) {
            if (!StringUtils.isEmpty((String)catalogName)) {
                name = name + "." + catalogName;
            }
            name = name + ".groovy";
        }
        name = name.replace(" ", "_").trim();
        LOGGER.fine("set file name to: " + name);
        return name;
    }
}

