// CHECKSTYLE:OFF

package org.jenkinsci.plugins.scriptsecurity.scripts;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ScriptApprovalLink.dangerous}: {@code {0} approved
     * dangerous signatures}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} approved dangerous signatures}
     */
    public static String ScriptApprovalLink_dangerous(Object arg0) {
        return holder.format("ScriptApprovalLink.dangerous", arg0);
    }

    /**
     * Key {@code ScriptApprovalLink.dangerous}: {@code {0} approved
     * dangerous signatures}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} approved dangerous signatures}
     */
    public static Localizable _ScriptApprovalLink_dangerous(Object arg0) {
        return new Localizable(holder, "ScriptApprovalLink.dangerous", arg0);
    }

    /**
     * Key {@code ScriptApprovalLink.outstandingScript}: {@code {0} scripts
     * pending approval}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} scripts pending approval}
     */
    public static String ScriptApprovalLink_outstandingScript(Object arg0) {
        return holder.format("ScriptApprovalLink.outstandingScript", arg0);
    }

    /**
     * Key {@code ScriptApprovalLink.outstandingScript}: {@code {0} scripts
     * pending approval}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} scripts pending approval}
     */
    public static Localizable _ScriptApprovalLink_outstandingScript(Object arg0) {
        return new Localizable(holder, "ScriptApprovalLink.outstandingScript", arg0);
    }

    /**
     * Key {@code ClasspathEntry.path.notExists}: {@code Specified path does
     * not exist}.
     * 
     * @return
     *     {@code Specified path does not exist}
     */
    public static String ClasspathEntry_path_notExists() {
        return holder.format("ClasspathEntry.path.notExists");
    }

    /**
     * Key {@code ClasspathEntry.path.notExists}: {@code Specified path does
     * not exist}.
     * 
     * @return
     *     {@code Specified path does not exist}
     */
    public static Localizable _ClasspathEntry_path_notExists() {
        return new Localizable(holder, "ClasspathEntry.path.notExists");
    }

    /**
     * Key {@code ScriptApprovalNote.message}: {@code Administrators can
     * decide whether to approve or reject this signature.}.
     * 
     * @return
     *     {@code Administrators can decide whether to approve or reject this
     *     signature.}
     */
    public static String ScriptApprovalNote_message() {
        return holder.format("ScriptApprovalNote.message");
    }

    /**
     * Key {@code ScriptApprovalNote.message}: {@code Administrators can
     * decide whether to approve or reject this signature.}.
     * 
     * @return
     *     {@code Administrators can decide whether to approve or reject this
     *     signature.}
     */
    public static Localizable _ScriptApprovalNote_message() {
        return new Localizable(holder, "ScriptApprovalNote.message");
    }

    /**
     * Key {@code ClasspathEntry.path.noDirsAllowed}: {@code Class
     * directories are not allowed as classpath entries.}.
     * 
     * @return
     *     {@code Class directories are not allowed as classpath entries.}
     */
    public static String ClasspathEntry_path_noDirsAllowed() {
        return holder.format("ClasspathEntry.path.noDirsAllowed");
    }

    /**
     * Key {@code ClasspathEntry.path.noDirsAllowed}: {@code Class
     * directories are not allowed as classpath entries.}.
     * 
     * @return
     *     {@code Class directories are not allowed as classpath entries.}
     */
    public static Localizable _ClasspathEntry_path_noDirsAllowed() {
        return new Localizable(holder, "ClasspathEntry.path.noDirsAllowed");
    }

    /**
     * Key {@code ScriptApprovalLink.outstandingSignature}: {@code {0}
     * signatures pending approval}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} signatures pending approval}
     */
    public static String ScriptApprovalLink_outstandingSignature(Object arg0) {
        return holder.format("ScriptApprovalLink.outstandingSignature", arg0);
    }

    /**
     * Key {@code ScriptApprovalLink.outstandingSignature}: {@code {0}
     * signatures pending approval}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} signatures pending approval}
     */
    public static Localizable _ScriptApprovalLink_outstandingSignature(Object arg0) {
        return new Localizable(holder, "ScriptApprovalLink.outstandingSignature", arg0);
    }

    /**
     * Key {@code ClasspathEntry.path.notApproved}: {@code This classpath
     * entry is not approved. Require an approval before execution.}.
     * 
     * @return
     *     {@code This classpath entry is not approved. Require an approval
     *     before execution.}
     */
    public static String ClasspathEntry_path_notApproved() {
        return holder.format("ClasspathEntry.path.notApproved");
    }

    /**
     * Key {@code ClasspathEntry.path.notApproved}: {@code This classpath
     * entry is not approved. Require an approval before execution.}.
     * 
     * @return
     *     {@code This classpath entry is not approved. Require an approval
     *     before execution.}
     */
    public static Localizable _ClasspathEntry_path_notApproved() {
        return new Localizable(holder, "ClasspathEntry.path.notApproved");
    }

    /**
     * Key {@code ScriptApprovalLink.outstandingClasspath}: {@code {0}
     * classpath entries pending approval}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} classpath entries pending approval}
     */
    public static String ScriptApprovalLink_outstandingClasspath(Object arg0) {
        return holder.format("ScriptApprovalLink.outstandingClasspath", arg0);
    }

    /**
     * Key {@code ScriptApprovalLink.outstandingClasspath}: {@code {0}
     * classpath entries pending approval}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} classpath entries pending approval}
     */
    public static Localizable _ScriptApprovalLink_outstandingClasspath(Object arg0) {
        return new Localizable(holder, "ScriptApprovalLink.outstandingClasspath", arg0);
    }

}
