/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.scripts;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ManagementLink;
import hudson.security.Permission;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
public final class ScriptApprovalLink
extends ManagementLink {
    public String getIconFileName() {
        if (ScriptApproval.get().isEmpty()) {
            return null;
        }
        return "symbol-edit-note";
    }

    public String getUrlName() {
        return ScriptApproval.get().getUrlName();
    }

    public String getDisplayName() {
        return "In-process Script Approval";
    }

    public String getDescription() {
        int dangerous;
        Object message = "Allows a Jenkins administrator to review proposed scripts (written e.g. in Groovy) which run inside the Jenkins process and so could bypass security restrictions.";
        int outstanding = ScriptApproval.get().getPendingScripts().size();
        if (outstanding > 0) {
            message = (String)message + " <strong>" + outstanding + " scripts pending approval.</strong>";
        }
        if ((outstanding = ScriptApproval.get().getPendingSignatures().size()) > 0) {
            message = (String)message + " <strong>" + outstanding + " signatures pending approval.</strong>";
        }
        if ((outstanding = ScriptApproval.get().getPendingClasspathEntries().size()) > 0) {
            message = (String)message + " <strong>" + outstanding + " classpath entries pending approval.</strong>";
        }
        if ((dangerous = ScriptApproval.get().getDangerousApprovedSignatures().length) > 0) {
            message = (String)message + " <strong><font color='red'>" + dangerous + " dangerous signatures</font> previously approved which ought not have been.</strong>";
        }
        return message;
    }

    @NonNull
    public Permission getRequiredPermission() {
        return Jenkins.ADMINISTER;
    }

    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.SECURITY;
    }
}

