/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import java.beans.Introspector;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public final class SecureGroovyScript
extends AbstractDescribableImpl<SecureGroovyScript> {
    @Nonnull
    private final String script;
    private final boolean sandbox;
    @CheckForNull
    private final List<ClasspathEntry> classpath;
    private transient boolean calledConfiguring;
    static final Logger LOGGER = Logger.getLogger(SecureGroovyScript.class.getName());

    @DataBoundConstructor
    public SecureGroovyScript(@Nonnull String script, boolean sandbox, @CheckForNull List<ClasspathEntry> classpath) {
        this.script = script;
        this.sandbox = sandbox;
        this.classpath = classpath;
    }

    @Deprecated
    public SecureGroovyScript(@Nonnull String script, boolean sandbox) {
        this(script, sandbox, null);
    }

    private Object readResolve() {
        this.configuring(ApprovalContext.create());
        return this;
    }

    @Nonnull
    public String getScript() {
        return this.script;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    @Nonnull
    public List<ClasspathEntry> getClasspath() {
        return this.classpath != null ? this.classpath : Collections.emptyList();
    }

    public SecureGroovyScript configuring(ApprovalContext context) {
        this.calledConfiguring = true;
        if (!this.sandbox) {
            ScriptApproval.get().configuring(this.script, GroovyLanguage.get(), context);
        }
        for (ClasspathEntry entry : this.getClasspath()) {
            ScriptApproval.get().configuring(entry, context);
        }
        return this;
    }

    @CheckForNull
    private static Item currentItem() {
        StaplerRequest req = Stapler.getCurrentRequest();
        return req != null ? (Item)req.findAncestorObject(Item.class) : null;
    }

    public SecureGroovyScript configuringWithKeyItem() {
        ApprovalContext context = ApprovalContext.create();
        context = context.withCurrentUser().withItemAsKey(SecureGroovyScript.currentItem());
        return this.configuring(context);
    }

    public SecureGroovyScript configuringWithNonKeyItem() {
        ApprovalContext context = ApprovalContext.create();
        context = context.withCurrentUser().withItem(SecureGroovyScript.currentItem());
        return this.configuring(context);
    }

    private static void cleanUpLoader(ClassLoader loader, Set<ClassLoader> encounteredLoaders, Set<Class<?>> encounteredClasses) throws Exception {
        if (!(loader instanceof GroovyClassLoader)) {
            LOGGER.log(Level.FINER, "ignoring {0}", loader);
            return;
        }
        if (!encounteredLoaders.add(loader)) {
            return;
        }
        SecureGroovyScript.cleanUpLoader(loader.getParent(), encounteredLoaders, encounteredClasses);
        LOGGER.log(Level.FINER, "found {0}", String.valueOf(loader));
        SecureGroovyScript.cleanUpGlobalClassValue(loader);
        GroovyClassLoader gcl = (GroovyClassLoader)loader;
        for (Class clazz : gcl.getLoadedClasses()) {
            if (!encounteredClasses.add(clazz)) continue;
            LOGGER.log(Level.FINER, "found {0}", clazz.getName());
            Introspector.flushFromCaches(clazz);
            SecureGroovyScript.cleanUpGlobalClassSet(clazz);
            SecureGroovyScript.cleanUpObjectStreamClassCaches(clazz);
            SecureGroovyScript.cleanUpLoader(clazz.getClassLoader(), encounteredLoaders, encounteredClasses);
        }
        gcl.clearCache();
    }

    private static void cleanUpGlobalClassValue(@Nonnull ClassLoader loader) throws Exception {
        Class<?> classInfoC = Class.forName("org.codehaus.groovy.reflection.ClassInfo");
        Field globalClassValueF = classInfoC.getDeclaredField("globalClassValue");
        globalClassValueF.setAccessible(true);
        Object globalClassValue = globalClassValueF.get(null);
        Class<?> groovyClassValuePreJava7C = Class.forName("org.codehaus.groovy.reflection.GroovyClassValuePreJava7");
        if (!groovyClassValuePreJava7C.isInstance(globalClassValue)) {
            return;
        }
        Field mapF = groovyClassValuePreJava7C.getDeclaredField("map");
        mapF.setAccessible(true);
        Object map = mapF.get(globalClassValue);
        Class<?> groovyClassValuePreJava7Map = Class.forName("org.codehaus.groovy.reflection.GroovyClassValuePreJava7$GroovyClassValuePreJava7Map");
        Collection entries = (Collection)groovyClassValuePreJava7Map.getMethod("values", new Class[0]).invoke(map, new Object[0]);
        Method removeM = groovyClassValuePreJava7Map.getMethod("remove", Object.class);
        Class<?> entryC = Class.forName("org.codehaus.groovy.util.AbstractConcurrentMapBase$Entry");
        Method getValueM = entryC.getMethod("getValue", new Class[0]);
        ArrayList<Object> toRemove = new ArrayList<Object>();
        try {
            Field classRefF = classInfoC.getDeclaredField("classRef");
            classRefF.setAccessible(true);
            for (Object e : entries) {
                Object value = getValueM.invoke(e, new Object[0]);
                toRemove.add(((WeakReference)classRefF.get(value)).get());
            }
        }
        catch (NoSuchFieldException x) {
            Field klazzF = classInfoC.getDeclaredField("klazz");
            klazzF.setAccessible(true);
            for (Object entry : entries) {
                Object value = getValueM.invoke(entry, new Object[0]);
                toRemove.add((Class)klazzF.get(value));
            }
        }
        Iterator it = toRemove.iterator();
        while (it.hasNext()) {
            Class klazz = (Class)it.next();
            ClassLoader classLoader = klazz.getClassLoader();
            if (classLoader == loader) continue;
            it.remove();
            LOGGER.log(Level.FINEST, "ignoring {0} with loader {1}", new Object[]{klazz, String.valueOf(classLoader)});
        }
        LOGGER.log(Level.FINE, "cleaning up {0} associated with {1}", new Object[]{((Object)toRemove).toString(), loader.toString()});
        for (Class clazz : toRemove) {
            removeM.invoke(map, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpGlobalClassSet(@Nonnull Class<?> clazz) throws Exception {
        Class<?> classInfoC = Class.forName("org.codehaus.groovy.reflection.ClassInfo");
        Field globalClassSetF = classInfoC.getDeclaredField("globalClassSet");
        globalClassSetF.setAccessible(true);
        Object globalClassSet = globalClassSetF.get(null);
        try {
            classInfoC.getDeclaredField("classRef");
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Field itemsF = globalClassSet.getClass().getDeclaredField("items");
            itemsF.setAccessible(true);
            Object items = itemsF.get(globalClassSet);
            Method iteratorM = items.getClass().getMethod("iterator", new Class[0]);
            Field klazzF = classInfoC.getDeclaredField("klazz");
            klazzF.setAccessible(true);
            Object object = items;
            synchronized (object) {
                Iterator iterator = (Iterator)iteratorM.invoke(items, new Object[0]);
                while (iterator.hasNext()) {
                    Object classInfo = iterator.next();
                    if (classInfo == null) {
                        LOGGER.finer("JENKINS-41945: ignoring null ClassInfo from ManagedLinkedList.Iter.next");
                        continue;
                    }
                    if (klazzF.get(classInfo) != clazz) continue;
                    iterator.remove();
                    LOGGER.log(Level.FINER, "cleaning up {0} from GlobalClassSet", clazz.getName());
                }
            }
            return;
        }
    }

    private static void cleanUpObjectStreamClassCaches(@Nonnull Class<?> clazz) throws Exception {
        Class<?> cachesC = Class.forName("java.io.ObjectStreamClass$Caches");
        block0: for (String cacheFName : new String[]{"localDescs", "reflectors"}) {
            Field cacheF = cachesC.getDeclaredField(cacheFName);
            cacheF.setAccessible(true);
            ConcurrentMap cache = (ConcurrentMap)cacheF.get(null);
            Iterator iterator = cache.entrySet().iterator();
            while (iterator.hasNext()) {
                if (((Reference)iterator.next().getKey()).get() != clazz) continue;
                iterator.remove();
                LOGGER.log(Level.FINER, "cleaning up {0} from ObjectStreamClass.Caches.{1}", new Object[]{clazz.getName(), cacheFName});
                continue block0;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Managed by GroovyShell.")
    public Object evaluate(ClassLoader loader, Binding binding) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecureGroovyScript> {
        public String getDisplayName() {
            return "";
        }

        public FormValidation doCheckScript(@QueryParameter String value, @QueryParameter boolean sandbox) {
            try {
                new GroovyShell(Jenkins.getInstance().getPluginManager().uberClassLoader).parse(value);
            }
            catch (CompilationFailedException x) {
                return FormValidation.error((String)x.getLocalizedMessage());
            }
            return sandbox ? FormValidation.ok() : ScriptApproval.get().checking(value, GroovyLanguage.get());
        }
    }

    private static final class CleanGroovyClassLoader
    extends GroovyClassLoader {
        CleanGroovyClassLoader(ClassLoader loader, CompilerConfiguration config) {
            super(loader, config);
        }

        CleanGroovyClassLoader(ClassLoader loader) {
            super(loader);
        }

        protected GroovyClassLoader.ClassCollector createCollector(CompilationUnit unit, SourceUnit su) {
            return new CleanClassCollector(unit, su);
        }

        private final class CleanClassCollector
        extends GroovyClassLoader.ClassCollector {
            CleanClassCollector(CompilationUnit unit, SourceUnit su) {
                super(null, unit, su);
            }

            public GroovyClassLoader getDefiningClassLoader() {
                return CleanGroovyClassLoader.this;
            }
        }
    }
}

