/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import com.google.common.primitives.Primitives;
import groovy.lang.GString;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ClassUtils;

class GroovyCallSiteSelector {
    private static boolean matches(@Nonnull Class<?>[] parameterTypes, @Nonnull Object[] parameters, boolean varargs) {
        if (varargs) {
            parameters = GroovyCallSiteSelector.parametersForVarargs(parameterTypes, parameters);
        }
        if (parameters.length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameters[i] == null) {
                if (!parameterTypes[i].isPrimitive()) continue;
                return false;
            }
            if (parameterTypes[i].isInstance(parameters[i]) || parameterTypes[i].isPrimitive() && parameters[i] != null && GroovyCallSiteSelector.isInstancePrimitive(ClassUtils.primitiveToWrapper(parameterTypes[i]), parameters[i]) || parameterTypes[i] == String.class && parameters[i] instanceof GString) continue;
            return false;
        }
        return true;
    }

    private static Object[] parametersForVarargs(Class<?>[] parameterTypes, Object[] parameters) {
        int fixedLen = parameterTypes.length - 1;
        Class<?> componentType = parameterTypes[fixedLen].getComponentType();
        assert (componentType != null);
        int arrayLength = parameters.length - fixedLen;
        if (arrayLength >= 0) {
            if (arrayLength == 1 && parameterTypes[fixedLen].isInstance(parameters[fixedLen])) {
                return parameters;
            }
            Object array = Array.newInstance(componentType, arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Array.set(array, i, parameters[fixedLen + i]);
            }
            Object[] parameters2 = new Object[fixedLen + 1];
            System.arraycopy(parameters, 0, parameters2, 0, fixedLen);
            parameters2[fixedLen] = array;
            return parameters2;
        }
        return parameters;
    }

    private static boolean isInstancePrimitive(@Nonnull Class<?> type, @Nonnull Object instance) {
        if (type.isInstance(instance)) {
            return true;
        }
        if (instance instanceof Number) {
            Long n;
            if (type == Long.class && instance instanceof Integer) {
                return true;
            }
            if (type == Integer.class && instance instanceof Long && (n = (Long)instance) >= Integer.MIN_VALUE && n <= Integer.MAX_VALUE) {
                return true;
            }
        }
        return false;
    }

    @CheckForNull
    public static Method method(@Nonnull Object receiver, @Nonnull String method, @Nonnull Object[] args) {
        Method candidate;
        for (Class<?> c : GroovyCallSiteSelector.types(receiver)) {
            Method candidate2 = GroovyCallSiteSelector.findMatchingMethod(c, method, args);
            if (candidate2 == null) continue;
            return candidate2;
        }
        if (receiver instanceof GString && (candidate = GroovyCallSiteSelector.findMatchingMethod(String.class, method, args)) != null) {
            return candidate;
        }
        return null;
    }

    @CheckForNull
    public static Constructor<?> constructor(@Nonnull Class<?> receiver, @Nonnull Object[] args) {
        for (Constructor<?> c : receiver.getDeclaredConstructors()) {
            if (!GroovyCallSiteSelector.matches(c.getParameterTypes(), args, c.isVarArgs())) continue;
            return c;
        }
        if (args.length == 1 && args[0] instanceof Map) {
            for (Constructor<?> c : receiver.getDeclaredConstructors()) {
                if (c.getParameterTypes().length != 0 || c.isVarArgs()) continue;
                return c;
            }
        }
        return null;
    }

    @CheckForNull
    public static Method staticMethod(@Nonnull Class<?> receiver, @Nonnull String method, @Nonnull Object[] args) {
        return GroovyCallSiteSelector.findMatchingMethod(receiver, method, args);
    }

    private static Method findMatchingMethod(Class<?> receiver, String method, Object[] args) {
        Method candidate = null;
        for (Method m : receiver.getDeclaredMethods()) {
            if (!m.getName().equals(method) || !GroovyCallSiteSelector.matches(m.getParameterTypes(), args, m.isVarArgs()) || candidate != null && !GroovyCallSiteSelector.isMoreSpecific(m, candidate)) continue;
            candidate = m;
        }
        return candidate;
    }

    @CheckForNull
    public static Field field(@Nonnull Object receiver, @Nonnull String field) {
        for (Class<?> c : GroovyCallSiteSelector.types(receiver)) {
            for (Field f : c.getDeclaredFields()) {
                if (!f.getName().equals(field)) continue;
                return f;
            }
        }
        return null;
    }

    @CheckForNull
    public static Field staticField(@Nonnull Class<?> receiver, @Nonnull String field) {
        for (Field f : receiver.getDeclaredFields()) {
            if (!f.getName().equals(field)) continue;
            return f;
        }
        return null;
    }

    private static Iterable<Class<?>> types(@Nonnull Object o) {
        LinkedHashSet types = new LinkedHashSet();
        GroovyCallSiteSelector.visitTypes(types, o.getClass());
        return types;
    }

    private static void visitTypes(@Nonnull Set<Class<?>> types, @Nonnull Class<?> c) {
        Class<?> s = c.getSuperclass();
        if (s != null) {
            GroovyCallSiteSelector.visitTypes(types, s);
        }
        for (Class<?> i : c.getInterfaces()) {
            GroovyCallSiteSelector.visitTypes(types, i);
        }
        types.add(c);
    }

    private static boolean isMoreSpecific(Method more, Method less) {
        Class<?>[] moreParams = more.getParameterTypes();
        Class<?>[] lessParams = less.getParameterTypes();
        if (less.isVarArgs() && !more.isVarArgs()) {
            return true;
        }
        if (!less.isVarArgs() && more.isVarArgs()) {
            return false;
        }
        if (moreParams.length != lessParams.length) {
            throw new IllegalStateException("cannot compare " + more + " to " + less);
        }
        for (int i = 0; i < moreParams.length; ++i) {
            Class lessParam;
            Class moreParam = Primitives.wrap(moreParams[i]);
            if (moreParam.isAssignableFrom(lessParam = Primitives.wrap(lessParams[i]))) {
                return false;
            }
            if (lessParam.isAssignableFrom(moreParam)) {
                return true;
            }
            if (moreParam == Long.class && lessParam == Integer.class) {
                return false;
            }
            if (moreParam != Integer.class || lessParam != Long.class) continue;
            return true;
        }
        return more.toString().compareTo(less.toString()) > 0;
    }

    private GroovyCallSiteSelector() {
    }
}

