/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.scripts;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.RootAction;
import hudson.model.Saveable;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.XStream2;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.AclAwareWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.StaticWhitelist;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalListener;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.jenkinsci.plugins.scriptsecurity.scripts.Language;
import org.jenkinsci.plugins.scriptsecurity.scripts.Messages;
import org.jenkinsci.plugins.scriptsecurity.scripts.UnapprovedClasspathException;
import org.jenkinsci.plugins.scriptsecurity.scripts.UnapprovedUsageException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.bind.JavaScriptMethod;

@Extension
public class ScriptApproval
implements RootAction,
Saveable {
    private static final Logger LOG = Logger.getLogger(ScriptApproval.class.getName());
    private static final XStream2 XSTREAM2 = new XStream2();
    private final TreeSet<String> approvedScriptHashes = new TreeSet();
    private final TreeSet<String> approvedSignatures = new TreeSet();
    private TreeSet<String> aclApprovedSignatures;
    private TreeSet<ApprovedClasspathEntry> approvedClasspathEntries;
    private final LinkedHashSet<PendingScript> pendingScripts = new LinkedHashSet();
    private final LinkedHashSet<PendingSignature> pendingSignatures = new LinkedHashSet();
    private TreeSet<PendingClasspathEntry> pendingClasspathEntries;

    @Nonnull
    public static ScriptApproval get() {
        Jenkins jenkins = ScriptApproval.getActiveJenkinsInstance();
        ScriptApproval instance = (ScriptApproval)jenkins.getExtensionList(RootAction.class).get(ScriptApproval.class);
        if (instance == null) {
            throw new IllegalStateException("maybe need to rebuild plugin?");
        }
        return instance;
    }

    void addApprovedClasspathEntry(ApprovedClasspathEntry acp) {
        this.approvedClasspathEntries.add(acp);
    }

    @CheckForNull
    private PendingClasspathEntry getPendingClasspathEntry(@Nonnull String hash) {
        PendingClasspathEntry e = this.pendingClasspathEntries.floor(PendingClasspathEntry.searchKeyFor(hash));
        if (e != null && e.hash.equals(hash)) {
            return e;
        }
        return null;
    }

    void addPendingClasspathEntry(PendingClasspathEntry pcp) {
        this.pendingClasspathEntries.add(pcp);
    }

    public ScriptApproval() {
        try {
            this.load();
        }
        catch (IOException x) {
            LOG.log(Level.WARNING, null, x);
        }
        if (this.aclApprovedSignatures == null) {
            this.aclApprovedSignatures = new TreeSet();
        }
        if (this.approvedClasspathEntries == null) {
            this.approvedClasspathEntries = new TreeSet();
        }
        if (this.pendingClasspathEntries == null) {
            this.pendingClasspathEntries = new TreeSet();
        }
        boolean changed = false;
        Iterator<ApprovedClasspathEntry> i = this.approvedClasspathEntries.iterator();
        while (i.hasNext()) {
            if (!i.next().isClassDirectory()) continue;
            i.remove();
            changed = true;
        }
        if (changed) {
            try {
                this.save();
            }
            catch (IOException x) {
                LOG.log(Level.WARNING, "Unable to save changes after cleaning accepted class directories", x);
            }
        }
    }

    private static String hash(String script, String language) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(language.getBytes("UTF-8"));
            digest.update((byte)58);
            digest.update(script.getBytes("UTF-8"));
            return Util.toHexString((byte[])digest.digest());
        }
        catch (NoSuchAlgorithmException x) {
            throw new AssertionError((Object)x);
        }
        catch (UnsupportedEncodingException x) {
            throw new AssertionError((Object)x);
        }
    }

    /*
     * Loose catch block
     */
    static String hashClasspathEntry(URL entry) throws IOException {
        InputStream is = entry.openStream();
        try {
            FilterInputStream input = null;
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                input = new DigestInputStream(new BufferedInputStream(is), digest);
                byte[] buffer = new byte[1024];
                while (input.read(buffer) != -1) {
                }
                String string = Util.toHexString((byte[])digest.digest());
                return string;
            }
            catch (NoSuchAlgorithmException x) {
                throw new AssertionError((Object)x);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            is.close();
        }
    }

    public synchronized String configuring(@Nonnull String script, @Nonnull Language language, @Nonnull ApprovalContext context) {
        String hash = ScriptApproval.hash(script, language.getName());
        Jenkins jenkins = ScriptApproval.getActiveJenkinsInstance();
        if (!this.approvedScriptHashes.contains(hash)) {
            if (!jenkins.isUseSecurity() || Jenkins.getAuthentication() != ACL.SYSTEM && jenkins.hasPermission(Jenkins.RUN_SCRIPTS)) {
                this.approvedScriptHashes.add(hash);
            } else {
                String key = context.getKey();
                if (key != null) {
                    Iterator it = this.pendingScripts.iterator();
                    while (it.hasNext()) {
                        if (!key.equals(((PendingScript)it.next()).getContext().getKey())) continue;
                        it.remove();
                    }
                }
                this.pendingScripts.add(new PendingScript(script, language, context));
            }
            try {
                this.save();
            }
            catch (IOException x) {
                LOG.log(Level.WARNING, null, x);
            }
        }
        return script;
    }

    public synchronized String using(@Nonnull String script, @Nonnull Language language) throws UnapprovedUsageException {
        if (script.length() == 0) {
            return script;
        }
        String hash = ScriptApproval.hash(script, language.getName());
        if (!this.approvedScriptHashes.contains(hash)) {
            throw new UnapprovedUsageException(hash);
        }
        return script;
    }

    synchronized boolean isScriptHashApproved(String hash) {
        return this.approvedScriptHashes.contains(hash);
    }

    public synchronized void configuring(@Nonnull ClasspathEntry entry, @Nonnull ApprovalContext context) {
        String hash;
        if (entry.isClassDirectory()) {
            LOG.log(Level.WARNING, "{0} is a class directory, which are not allowed. Ignored in configuration, use will be rejected", entry.getURL());
            return;
        }
        Jenkins jenkins = ScriptApproval.getActiveJenkinsInstance();
        URL url = entry.getURL();
        try {
            hash = ScriptApproval.hashClasspathEntry(url);
        }
        catch (IOException x) {
            LOG.log(Level.WARNING, null, x);
            return;
        }
        ApprovedClasspathEntry acp = new ApprovedClasspathEntry(hash, url);
        if (!this.approvedClasspathEntries.contains(acp)) {
            boolean shouldSave = false;
            PendingClasspathEntry pcp = new PendingClasspathEntry(hash, url, context);
            if (!jenkins.isUseSecurity() || Jenkins.getAuthentication() != ACL.SYSTEM && jenkins.hasPermission(Jenkins.RUN_SCRIPTS)) {
                LOG.log(Level.FINE, "Classpath entry {0} ({1}) is approved as configured with RUN_SCRIPTS permission.", new Object[]{url, hash});
                this.pendingClasspathEntries.remove(pcp);
                this.approvedClasspathEntries.add(acp);
                shouldSave = true;
            } else if (this.pendingClasspathEntries.add(pcp)) {
                LOG.log(Level.FINE, "{0} ({1}) is pending", new Object[]{url, hash});
                shouldSave = true;
            }
            if (shouldSave) {
                try {
                    this.save();
                }
                catch (IOException x) {
                    LOG.log(Level.WARNING, null, x);
                }
            }
        }
    }

    public synchronized FormValidation checking(@Nonnull ClasspathEntry entry) {
        Jenkins jenkins = ScriptApproval.getActiveJenkinsInstance();
        if (entry.isClassDirectory()) {
            return FormValidation.error((String)Messages.ClasspathEntry_path_noDirsAllowed());
        }
        URL url = entry.getURL();
        try {
            if (!jenkins.hasPermission(Jenkins.RUN_SCRIPTS) && !this.approvedClasspathEntries.contains(new ApprovedClasspathEntry(ScriptApproval.hashClasspathEntry(url), url))) {
                return FormValidation.error((String)Messages.ClasspathEntry_path_notApproved());
            }
            return FormValidation.ok();
        }
        catch (FileNotFoundException x) {
            return FormValidation.error((String)Messages.ClasspathEntry_path_notExists());
        }
        catch (IOException x) {
            return FormValidation.error((Throwable)x, (String)("Could not verify: " + url));
        }
    }

    public synchronized void using(@Nonnull ClasspathEntry entry) throws IOException, UnapprovedClasspathException {
        URL url = entry.getURL();
        String hash = ScriptApproval.hashClasspathEntry(url);
        if (!this.approvedClasspathEntries.contains(new ApprovedClasspathEntry(hash, url))) {
            if (entry.isClassDirectory()) {
                LOG.log(Level.WARNING, "{0} ({1}) is a class directory, which are not allowed.", new Object[]{url, hash});
            } else {
                ApprovalContext context = ApprovalContext.create();
                if (this.pendingClasspathEntries.add(new PendingClasspathEntry(hash, url, context))) {
                    LOG.log(Level.FINE, "{0} ({1}) is pending.", new Object[]{url, hash});
                    try {
                        this.save();
                    }
                    catch (IOException x) {
                        LOG.log(Level.WARNING, null, x);
                    }
                }
            }
            throw new UnapprovedClasspathException(url, hash);
        }
        LOG.log(Level.FINER, "{0} ({1}) had been approved", new Object[]{url, hash});
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="https://github.com/jenkinsci/jenkins/pull/2094")
    public synchronized FormValidation checking(@Nonnull String script, @Nonnull Language language) {
        if (!Jenkins.getInstance().hasPermission(Jenkins.RUN_SCRIPTS) && !this.approvedScriptHashes.contains(ScriptApproval.hash(script, language.getName()))) {
            return FormValidation.warningWithMarkup((String)"A Jenkins administrator will need to approve this script before it can be used.");
        }
        return FormValidation.ok();
    }

    public synchronized String preapprove(@Nonnull String script, @Nonnull Language language) {
        this.approvedScriptHashes.add(ScriptApproval.hash(script, language.getName()));
        return script;
    }

    public synchronized void preapproveAll() {
        for (PendingScript ps : this.pendingScripts) {
            this.approvedScriptHashes.add(ps.getHash());
        }
        this.pendingScripts.clear();
    }

    public synchronized RejectedAccessException accessRejected(@Nonnull RejectedAccessException x, @Nonnull ApprovalContext context) {
        String signature = x.getSignature();
        if (signature != null && this.pendingSignatures.add(new PendingSignature(signature, x.isDangerous(), context))) {
            try {
                this.save();
            }
            catch (IOException x2) {
                LOG.log(Level.WARNING, null, x2);
            }
        }
        return x;
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized String[] getApprovedSignatures() {
        return this.approvedSignatures.toArray(new String[this.approvedSignatures.size()]);
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized String[] getDangerousApprovedSignatures() {
        ArrayList<String> dangerous = new ArrayList<String>();
        for (String sig : this.approvedSignatures) {
            if (!StaticWhitelist.isBlacklisted(sig)) continue;
            dangerous.add(sig);
        }
        return dangerous.toArray(new String[dangerous.size()]);
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized String[] getAclApprovedSignatures() {
        return this.aclApprovedSignatures.toArray(new String[this.aclApprovedSignatures.size()]);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "scriptApproval";
    }

    @CheckForNull
    private XmlFile getConfigFile() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return null;
        }
        return new XmlFile((XStream)XSTREAM2, new File(jenkins.getRootDir(), this.getUrlName() + ".xml"));
    }

    private synchronized void load() throws IOException {
        XmlFile xml = this.getConfigFile();
        if (xml != null && xml.exists()) {
            xml.unmarshal((Object)this);
        }
    }

    public synchronized void save() throws IOException {
        XmlFile configFile = this.getConfigFile();
        if (configFile == null) {
            throw new IOException("Cannot get config file. Probably, Jenkins is not ready");
        }
        configFile.write((Object)this);
    }

    @Restricted(value={NoExternalUse.class})
    public Set<PendingScript> getPendingScripts() {
        return this.pendingScripts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JavaScriptMethod
    @Restricted(value={NoExternalUse.class})
    public void approveScript(String hash) throws IOException {
        Jenkins jenkins = ScriptApproval.getJenkins();
        jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
        ScriptApproval scriptApproval = this;
        synchronized (scriptApproval) {
            this.approvedScriptHashes.add(hash);
            this.removePendingScript(hash);
            this.save();
        }
        SecurityContext orig = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            for (ApprovalListener listener : jenkins.getExtensionList(ApprovalListener.class)) {
                listener.onApproved(hash);
            }
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)orig);
        }
    }

    @JavaScriptMethod
    @Restricted(value={NoExternalUse.class})
    public synchronized void denyScript(String hash) throws IOException {
        Jenkins jenkins = ScriptApproval.getJenkins();
        jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
        this.approvedScriptHashes.remove(hash);
        this.removePendingScript(hash);
        this.save();
    }

    private synchronized void removePendingScript(String hash) {
        Iterator it = this.pendingScripts.iterator();
        while (it.hasNext()) {
            if (!((PendingScript)it.next()).getHash().equals(hash)) continue;
            it.remove();
            break;
        }
    }

    @JavaScriptMethod
    @Restricted(value={NoExternalUse.class})
    public synchronized void clearApprovedScripts() throws IOException {
        Jenkins jenkins = ScriptApproval.getJenkins();
        jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
        this.approvedScriptHashes.clear();
        this.save();
    }

    @Restricted(value={NoExternalUse.class})
    public Set<PendingSignature> getPendingSignatures() {
        return this.pendingSignatures;
    }

    private String[][] reconfigure(@NonNull Jenkins jenkins) throws IOException {
        ApprovedWhitelist awl = (ApprovedWhitelist)jenkins.getExtensionList(Whitelist.class).get(ApprovedWhitelist.class);
        if (awl != null) {
            return awl.reconfigure();
        }
        return new String[][]{new String[0], new String[0], new String[0]};
    }

    @JavaScriptMethod
    @Restricted(value={NoExternalUse.class})
    public synchronized String[][] approveSignature(String signature) throws IOException {
        Jenkins jenkins = ScriptApproval.getJenkins();
        jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
        this.pendingSignatures.remove(new PendingSignature(signature, false, ApprovalContext.create()));
        this.approvedSignatures.add(signature);
        this.save();
        return this.reconfigure(jenkins);
    }

    @JavaScriptMethod
    @Restricted(value={NoExternalUse.class})
    public synchronized String[][] aclApproveSignature(String signature) throws IOException {
        Jenkins jenkins = ScriptApproval.getJenkins();
        jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
        this.pendingSignatures.remove(new PendingSignature(signature, false, ApprovalContext.create()));
        this.aclApprovedSignatures.add(signature);
        this.save();
        return this.reconfigure(jenkins);
    }

    @JavaScriptMethod
    @Restricted(value={NoExternalUse.class})
    public synchronized void denySignature(String signature) throws IOException {
        Jenkins jenkins = ScriptApproval.getJenkins();
        jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
        this.pendingSignatures.remove(new PendingSignature(signature, false, ApprovalContext.create()));
        this.save();
    }

    @JavaScriptMethod
    @Restricted(value={NoExternalUse.class})
    public synchronized String[][] clearApprovedSignatures() throws IOException {
        Jenkins jenkins = ScriptApproval.getJenkins();
        jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
        this.approvedSignatures.clear();
        this.aclApprovedSignatures.clear();
        this.save();
        return this.reconfigure(jenkins);
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized List<ApprovedClasspathEntry> getApprovedClasspathEntries() {
        ArrayList<ApprovedClasspathEntry> r = new ArrayList<ApprovedClasspathEntry>(this.approvedClasspathEntries);
        Collections.sort(r, new Comparator<ApprovedClasspathEntry>(){

            @Override
            public int compare(ApprovedClasspathEntry o1, ApprovedClasspathEntry o2) {
                return o1.url.toString().compareTo(o2.url.toString());
            }
        });
        return r;
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized List<PendingClasspathEntry> getPendingClasspathEntries() {
        ArrayList<PendingClasspathEntry> r = new ArrayList<PendingClasspathEntry>(this.pendingClasspathEntries);
        Collections.sort(r, new Comparator<PendingClasspathEntry>(){

            @Override
            public int compare(PendingClasspathEntry o1, PendingClasspathEntry o2) {
                return o1.url.toString().compareTo(o2.url.toString());
            }
        });
        return r;
    }

    @JavaScriptMethod
    @Restricted(value={NoExternalUse.class})
    public JSON getClasspathRenderInfo() {
        JSONArray pendings = new JSONArray();
        for (PendingClasspathEntry cp : this.getPendingClasspathEntries()) {
            pendings.add((Object)new JSONObject().element("hash", (Object)cp.getHash()).element("path", (Object)ClasspathEntry.urlToPath(cp.getURL())));
        }
        JSONArray approveds = new JSONArray();
        for (ApprovedClasspathEntry cp : this.getApprovedClasspathEntries()) {
            approveds.add((Object)new JSONObject().element("hash", (Object)cp.getHash()).element("path", (Object)ClasspathEntry.urlToPath(cp.getURL())));
        }
        return new JSONArray().element((Collection)pendings).element((Collection)approveds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JavaScriptMethod
    @Restricted(value={NoExternalUse.class})
    public JSON approveClasspathEntry(String hash) throws IOException {
        Jenkins jenkins = ScriptApproval.getJenkins();
        jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
        URL url = null;
        ScriptApproval scriptApproval = this;
        synchronized (scriptApproval) {
            PendingClasspathEntry cp = this.getPendingClasspathEntry(hash);
            if (cp != null) {
                this.pendingClasspathEntries.remove(cp);
                url = cp.getURL();
                this.approvedClasspathEntries.add(new ApprovedClasspathEntry(hash, url));
                this.save();
            }
        }
        if (url != null) {
            SecurityContext orig = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                for (ApprovalListener listener : jenkins.getExtensionList(ApprovalListener.class)) {
                    listener.onApprovedClasspathEntry(hash, url);
                }
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)orig);
            }
        }
        return this.getClasspathRenderInfo();
    }

    @JavaScriptMethod
    @Restricted(value={NoExternalUse.class})
    public JSON denyClasspathEntry(String hash) throws IOException {
        Jenkins jenkins = ScriptApproval.getJenkins();
        jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
        PendingClasspathEntry cp = this.getPendingClasspathEntry(hash);
        if (cp != null) {
            this.pendingClasspathEntries.remove(cp);
            this.save();
        }
        return this.getClasspathRenderInfo();
    }

    @JavaScriptMethod
    @Restricted(value={NoExternalUse.class})
    public JSON denyApprovedClasspathEntry(String hash) throws IOException {
        Jenkins jenkins = ScriptApproval.getJenkins();
        jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
        if (this.approvedClasspathEntries.remove(new ApprovedClasspathEntry(hash, null))) {
            this.save();
        }
        return this.getClasspathRenderInfo();
    }

    @JavaScriptMethod
    @Restricted(value={NoExternalUse.class})
    public synchronized JSON clearApprovedClasspathEntries() throws IOException {
        Jenkins jenkins = ScriptApproval.getJenkins();
        jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
        this.approvedClasspathEntries.clear();
        this.save();
        return this.getClasspathRenderInfo();
    }

    @Nonnull
    private static Jenkins getJenkins() throws IOException {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IOException("Jenkins instance is not ready");
        }
        return jenkins;
    }

    @Nonnull
    private static Jenkins getActiveJenkinsInstance() throws IllegalStateException {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins instance is not ready");
        }
        return jenkins;
    }

    static {
        XSTREAM2.alias("com.cloudbees.hudson.plugins.modeling.scripts.ScriptApproval", ScriptApproval.class);
        XSTREAM2.alias("com.cloudbees.hudson.plugins.modeling.scripts.ScriptApproval$PendingScript", PendingScript.class);
        XSTREAM2.alias("com.cloudbees.hudson.plugins.modeling.scripts.ScriptApproval$PendingSignature", PendingSignature.class);
        XSTREAM2.alias("scriptApproval", ScriptApproval.class);
        XSTREAM2.alias("approvedClasspathEntry", ApprovedClasspathEntry.class);
        XSTREAM2.alias("pendingScript", PendingScript.class);
        XSTREAM2.alias("pendingSignature", PendingSignature.class);
        XSTREAM2.alias("pendingClasspathEntry", PendingClasspathEntry.class);
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static final class ApprovedWhitelist
    extends ProxyWhitelist {
        public ApprovedWhitelist() throws IOException {
            super(new Whitelist[0]);
            this.reconfigure();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String[][] reconfigure() throws IOException {
            ScriptApproval instance;
            ScriptApproval scriptApproval = instance = ScriptApproval.get();
            synchronized (scriptApproval) {
                this.reset(Collections.singleton(new AclAwareWhitelist(new StaticWhitelist(instance.approvedSignatures), new StaticWhitelist(instance.aclApprovedSignatures))));
                return new String[][]{instance.getApprovedSignatures(), instance.getAclApprovedSignatures(), instance.getDangerousApprovedSignatures()};
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class PendingClasspathEntry
    extends PendingThing
    implements Comparable<PendingClasspathEntry> {
        private final String hash;
        private final URL url;
        private static final ApprovalContext SEARCH_APPROVAL_CONTEXT = ApprovalContext.create();
        private static URL SEARCH_APPROVAL_URL;

        PendingClasspathEntry(@Nonnull String hash, @Nonnull URL url, @Nonnull ApprovalContext context) {
            super(context);
            this.hash = hash;
            this.url = url;
        }

        @Nonnull
        public String getHash() {
            return this.hash;
        }

        @Nonnull
        public URL getURL() {
            return this.url;
        }

        public int hashCode() {
            return this.getHash().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof PendingClasspathEntry && ((PendingClasspathEntry)obj).getHash().equals(this.getHash());
        }

        @Override
        public int compareTo(PendingClasspathEntry o) {
            return this.hash.compareTo(o.hash);
        }

        @Nonnull
        public static PendingClasspathEntry searchKeyFor(@Nonnull String hash) {
            PendingClasspathEntry entry = new PendingClasspathEntry(hash, SEARCH_APPROVAL_URL, SEARCH_APPROVAL_CONTEXT);
            return entry;
        }

        static {
            try {
                SEARCH_APPROVAL_URL = new URL("http://invalid.url/do/not/use");
            }
            catch (Throwable e) {
                LOG.log(Level.WARNING, "Unexpected exception", e);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class PendingSignature
    extends PendingThing {
        public final String signature;
        public final boolean dangerous;

        PendingSignature(@Nonnull String signature, boolean dangerous, @Nonnull ApprovalContext context) {
            super(context);
            this.signature = signature;
            this.dangerous = dangerous;
        }

        public String getHash() {
            return Integer.toHexString(this.hashCode());
        }

        public int hashCode() {
            return this.signature.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof PendingSignature && ((PendingSignature)obj).signature.equals(this.signature);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class PendingScript
    extends PendingThing {
        public final String script;
        private final String language;

        PendingScript(@Nonnull String script, @Nonnull Language language, @Nonnull ApprovalContext context) {
            super(context);
            this.script = script;
            this.language = language.getName();
        }

        public String getHash() {
            return ScriptApproval.hash(this.script, this.language);
        }

        public Language getLanguage() {
            Jenkins jenkins = ScriptApproval.getActiveJenkinsInstance();
            for (Language l : jenkins.getExtensionList(Language.class)) {
                if (!l.getName().equals(this.language)) continue;
                return l;
            }
            return new Language(){

                @Override
                public String getName() {
                    return PendingScript.this.language;
                }

                @Override
                public String getDisplayName() {
                    return "<missing language: " + PendingScript.this.language + ">";
                }
            };
        }

        public int hashCode() {
            return this.script.hashCode() ^ this.language.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof PendingScript && ((PendingScript)obj).language.equals(this.language) && ((PendingScript)obj).script.equals(this.script);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static abstract class PendingThing {
        @Deprecated
        private String user;
        @Nonnull
        private ApprovalContext context;

        PendingThing(@Nonnull ApprovalContext context) {
            this.context = context;
        }

        @Nonnull
        public ApprovalContext getContext() {
            return this.context;
        }

        private Object readResolve() {
            if (this.user != null) {
                this.context = ApprovalContext.create().withUser(this.user);
                this.user = null;
            }
            return this;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class ApprovedClasspathEntry
    implements Comparable<ApprovedClasspathEntry> {
        private final String hash;
        private final URL url;

        public ApprovedClasspathEntry(String hash, URL url) {
            this.hash = hash;
            this.url = url;
        }

        public String getHash() {
            return this.hash;
        }

        public URL getURL() {
            return this.url;
        }

        boolean isClassDirectory() {
            return ClasspathEntry.isClassDirectoryURL(this.url);
        }

        public int hashCode() {
            return this.hash.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ApprovedClasspathEntry && ((ApprovedClasspathEntry)obj).hash.equals(this.hash);
        }

        @Override
        public int compareTo(ApprovedClasspathEntry o) {
            return this.hash.compareTo(o.hash);
        }
    }
}

