/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.scripts;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.util.FormValidation;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public final class ClasspathEntry
extends AbstractDescribableImpl<ClasspathEntry> {
    @Nonnull
    private final URL url;

    @DataBoundConstructor
    public ClasspathEntry(@Nonnull String path) throws MalformedURLException {
        this.url = ClasspathEntry.pathToURL(path);
    }

    static URL pathToURL(String path) throws MalformedURLException {
        try {
            return new URL(path);
        }
        catch (MalformedURLException x) {
            return new File(path).toURI().toURL();
        }
    }

    private static File urlToFile(@Nonnull URL url) {
        if (url.getProtocol().equals("file")) {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    static String urlToPath(URL url) {
        File file = ClasspathEntry.urlToFile(url);
        return file != null ? file.getAbsolutePath() : url.toString();
    }

    static boolean isClassDirectoryURL(@Nonnull URL url) {
        File file = ClasspathEntry.urlToFile(url);
        if (file != null && file.isDirectory()) {
            return true;
        }
        String u = url.toExternalForm();
        return u.endsWith("/") && !u.startsWith("jar:");
    }

    public boolean isClassDirectory() {
        return ClasspathEntry.isClassDirectoryURL(this.url);
    }

    @Nonnull
    public String getPath() {
        return ClasspathEntry.urlToPath(this.url);
    }

    @Nonnull
    public URL getURL() {
        return this.url;
    }

    @CheckForNull
    private URI getURI() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public String toString() {
        return this.url.toString();
    }

    @SuppressFBWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="Method call has been optimized, but we still need URLs as a fallback")
    public boolean equals(Object obj) {
        if (!(obj instanceof ClasspathEntry)) {
            return false;
        }
        ClasspathEntry cmp = (ClasspathEntry)((Object)obj);
        URI uri = this.getURI();
        return uri != null ? uri.equals(cmp.getURI()) : this.url.equals(cmp.url);
    }

    @SuppressFBWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="Method call has been optimized, but we still need URLs as a fallback")
    public int hashCode() {
        URI uri = this.getURI();
        return uri != null ? uri.hashCode() : this.url.hashCode();
    }

    @Initializer(before=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void alias() {
        Items.XSTREAM2.alias("entry", ClasspathEntry.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ClasspathEntry> {
        public String getDisplayName() {
            return "ClasspathEntry";
        }

        public FormValidation doCheckPath(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warning((String)"Enter a file path or URL.");
            }
            try {
                return ScriptApproval.get().checking(new ClasspathEntry(value));
            }
            catch (MalformedURLException x) {
                return FormValidation.error((Throwable)x, (String)("Could not parse: " + value));
            }
        }
    }
}

