/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ClassUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;

public abstract class EnumeratingWhitelist
extends Whitelist {
    protected abstract List<MethodSignature> methodSignatures();

    protected abstract List<NewSignature> newSignatures();

    protected abstract List<MethodSignature> staticMethodSignatures();

    protected abstract List<FieldSignature> fieldSignatures();

    protected abstract List<FieldSignature> staticFieldSignatures();

    @Override
    public final boolean permitsMethod(Method method, Object receiver, Object[] args) {
        for (MethodSignature s : this.methodSignatures()) {
            if (!s.matches(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsConstructor(Constructor<?> constructor, Object[] args) {
        for (NewSignature s : this.newSignatures()) {
            if (!s.matches(constructor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsStaticMethod(Method method, Object[] args) {
        for (MethodSignature s : this.staticMethodSignatures()) {
            if (!s.matches(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsFieldGet(Field field, Object receiver) {
        for (FieldSignature s : this.fieldSignatures()) {
            if (!s.matches(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsFieldSet(Field field, Object receiver, Object value) {
        for (FieldSignature s : this.fieldSignatures()) {
            if (!s.matches(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsStaticFieldGet(Field field) {
        for (FieldSignature s : this.staticFieldSignatures()) {
            if (!s.matches(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsStaticFieldSet(Field field, Object value) {
        for (FieldSignature s : this.staticFieldSignatures()) {
            if (!s.matches(field)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static String getName(@Nonnull Class<?> c) {
        Class<?> e = c.getComponentType();
        if (e == null) {
            return c.getName();
        }
        return EnumeratingWhitelist.getName(e) + "[]";
    }

    @Nonnull
    public static String getName(@CheckForNull Object o) {
        return o == null ? "null" : EnumeratingWhitelist.getName(o.getClass());
    }

    private static String[] argumentTypes(Class<?>[] argumentTypes) {
        String[] s = new String[argumentTypes.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            s[i] = EnumeratingWhitelist.getName(argumentTypes[i]);
        }
        return s;
    }

    private static boolean is(String thisIdentifier, String identifier) {
        return thisIdentifier.equals("*") || identifier.equals(thisIdentifier);
    }

    static class StaticFieldSignature
    extends FieldSignature {
        StaticFieldSignature(String type, String field) {
            super(type, field);
        }

        @Override
        public String toString() {
            return "staticField " + this.signaturePart();
        }
    }

    public static class FieldSignature
    extends Signature {
        final String type;
        final String field;

        public FieldSignature(String type, String field) {
            this.type = type;
            this.field = field;
        }

        public FieldSignature(Class<?> type, String field) {
            this(EnumeratingWhitelist.getName(type), field);
        }

        boolean matches(Field f) {
            return EnumeratingWhitelist.is(this.field, f.getName()) && EnumeratingWhitelist.getName(f.getDeclaringClass()).equals(this.type);
        }

        @Override
        String signaturePart() {
            return this.type + ' ' + this.field;
        }

        @Override
        public String toString() {
            return "field " + this.signaturePart();
        }

        @Override
        boolean exists() throws Exception {
            try {
                this.type(this.type).getField(this.field);
                return true;
            }
            catch (NoSuchFieldException x) {
                return false;
            }
        }
    }

    public static final class NewSignature
    extends Signature {
        private final String type;
        private final String[] argumentTypes;

        public NewSignature(String type, String[] argumentTypes) {
            this.type = type;
            this.argumentTypes = (String[])argumentTypes.clone();
        }

        public NewSignature(Class<?> type, Class<?> ... argumentTypes) {
            this(EnumeratingWhitelist.getName(type), EnumeratingWhitelist.argumentTypes(argumentTypes));
        }

        boolean matches(Constructor c) {
            return EnumeratingWhitelist.getName(c.getDeclaringClass()).equals(this.type) && Arrays.equals(EnumeratingWhitelist.argumentTypes(c.getParameterTypes()), this.argumentTypes);
        }

        @Override
        String signaturePart() {
            return this.joinWithSpaces(new StringBuilder(this.type), this.argumentTypes).toString();
        }

        @Override
        public String toString() {
            return "new " + this.signaturePart();
        }

        @Override
        boolean exists() throws Exception {
            try {
                this.type(this.type).getConstructor(this.types(this.argumentTypes));
                return true;
            }
            catch (NoSuchMethodException x) {
                return false;
            }
        }
    }

    static class StaticMethodSignature
    extends MethodSignature {
        StaticMethodSignature(String receiverType, String method, String[] argumentTypes) {
            super(receiverType, method, argumentTypes);
        }

        @Override
        public String toString() {
            return "staticMethod " + this.signaturePart();
        }
    }

    public static class MethodSignature
    extends Signature {
        final String receiverType;
        final String method;
        final String[] argumentTypes;

        public MethodSignature(String receiverType, String method, String[] argumentTypes) {
            this.receiverType = receiverType;
            this.method = method;
            this.argumentTypes = (String[])argumentTypes.clone();
        }

        public MethodSignature(Class<?> receiverType, String method, Class<?> ... argumentTypes) {
            this(EnumeratingWhitelist.getName(receiverType), method, EnumeratingWhitelist.argumentTypes(argumentTypes));
        }

        boolean matches(Method m) {
            return EnumeratingWhitelist.is(this.method, m.getName()) && EnumeratingWhitelist.getName(m.getDeclaringClass()).equals(this.receiverType) && Arrays.equals(EnumeratingWhitelist.argumentTypes(m.getParameterTypes()), this.argumentTypes);
        }

        @Override
        public String toString() {
            return "method " + this.signaturePart();
        }

        @Override
        String signaturePart() {
            return this.joinWithSpaces(new StringBuilder(this.receiverType).append(' ').append(this.method), this.argumentTypes).toString();
        }

        @Override
        boolean exists() throws Exception {
            return this.exists(this.type(this.receiverType), true);
        }

        private boolean exists(Class<?> c, boolean start) throws Exception {
            Class<?> s = c.getSuperclass();
            if (s != null && this.exists(s, false)) {
                return !start;
            }
            for (Class<?> i : c.getInterfaces()) {
                if (!this.exists(i, false)) continue;
                return !start;
            }
            try {
                c.getDeclaredMethod(this.method, this.types(this.argumentTypes));
                return true;
            }
            catch (NoSuchMethodException x) {
                return false;
            }
        }
    }

    public static abstract class Signature
    implements Comparable<Signature> {
        public abstract String toString();

        final StringBuilder joinWithSpaces(StringBuilder b, String[] types) {
            for (String type : types) {
                b.append(' ').append(type);
            }
            return b;
        }

        abstract String signaturePart();

        @Override
        public int compareTo(Signature o) {
            int r = this.signaturePart().compareTo(o.signaturePart());
            return r != 0 ? r : this.toString().compareTo(o.toString());
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass() && this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        abstract boolean exists() throws Exception;

        final Class<?> type(String name) throws Exception {
            return ClassUtils.getClass((String)name);
        }

        final Class<?>[] types(String[] names) throws Exception {
            Class[] r = new Class[names.length];
            for (int i = 0; i < names.length; ++i) {
                r[i] = this.type(names[i]);
            }
            return r;
        }
    }
}

