/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scm_filter;

import java.util.regex.Pattern;
import jenkins.branch.BranchBuildStrategy;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.jenkinsci.plugins.scm_filter.CouldNotGetCommitDataException;
import org.jenkinsci.plugins.scm_filter.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommitMessageBranchBuildStrategy
extends BranchBuildStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitMessageBranchBuildStrategy.class);
    private final String pattern;
    private transient Pattern compiledPattern;

    public static String getDisplayName() {
        return Messages.CommitMessageBranchBuildStrategy_DisplayName();
    }

    public String getPattern() {
        return this.pattern;
    }

    public Pattern getCompiledPattern() {
        if (this.compiledPattern == null) {
            this.compiledPattern = Pattern.compile(this.pattern);
        }
        return this.compiledPattern;
    }

    public abstract String getMessage(SCMSource var1, SCMRevision var2) throws CouldNotGetCommitDataException;

    public CommitMessageBranchBuildStrategy(String pattern) {
        this.pattern = pattern;
    }

    public boolean isAutomaticBuild(SCMSource source, SCMHead head, SCMRevision currRevision, SCMRevision prevRevision) {
        String message = null;
        try {
            message = this.getMessage(source, currRevision);
        }
        catch (CouldNotGetCommitDataException e) {
            LOGGER.error("Could not attempt to prevent automatic build by commit message pattern because of an error when fetching the commit message", (Throwable)e);
            return true;
        }
        if (message == null) {
            LOGGER.info("Could not attempt to prevent automatic build by commit message pattern because commit message is null");
            return true;
        }
        if (this.getCompiledPattern().matcher(message).find()) {
            String ownerDisplayName = "Global";
            SCMSourceOwner owner = source.getOwner();
            if (owner != null) {
                ownerDisplayName = owner.getDisplayName();
            }
            LOGGER.info("Automatic build prevented for job [{}] because commit message [{}] matched expression [{}]", new Object[]{ownerDisplayName, message, this.pattern});
            return false;
        }
        return true;
    }
}

