/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Locale;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.impl.mock.MockSCMHead;

public class MockChangeRequestSCMHead
extends SCMHead
implements ChangeRequestSCMHead2 {
    private final String target;
    private final Integer number;
    private final SCMHeadOrigin origin;
    private final ChangeRequestCheckoutStrategy strategy;

    public MockChangeRequestSCMHead(SCMHeadOrigin origin, Integer number, String target, ChangeRequestCheckoutStrategy strategy, boolean singleStrategy) {
        super("CR-" + number + (String)(singleStrategy ? "" : "-" + strategy.name().toLowerCase(Locale.ENGLISH)));
        this.number = number;
        this.target = target;
        this.origin = origin;
        this.strategy = strategy;
    }

    public MockChangeRequestSCMHead(Integer number, String target) {
        this(null, number, target, ChangeRequestCheckoutStrategy.HEAD, true);
    }

    @NonNull
    public String getId() {
        return this.number.toString();
    }

    @NonNull
    public SCMHead getTarget() {
        return new MockSCMHead(this.target);
    }

    public Integer getNumber() {
        return this.number;
    }

    @NonNull
    public SCMHeadOrigin getOrigin() {
        return this.origin == null ? SCMHeadOrigin.DEFAULT : this.origin;
    }

    @NonNull
    public ChangeRequestCheckoutStrategy getCheckoutStrategy() {
        return this.strategy;
    }

    @NonNull
    public String getOriginName() {
        return this.getName();
    }
}

