/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.saml.SamlFormValidation;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SamlEncryptionData
extends AbstractDescribableImpl<SamlEncryptionData> {
    private final String keystorePath;
    @Deprecated
    private transient String keystorePassword;
    private Secret keystorePasswordSecret;
    @Deprecated
    private transient String privateKeyPassword;
    private Secret privateKeyPasswordSecret;
    private final String privateKeyAlias;
    private boolean forceSignRedirectBindingAuthnRequest;
    private boolean wantsAssertionsSigned;

    @DataBoundConstructor
    public SamlEncryptionData(String keystorePath, Secret keystorePassword, Secret privateKeyPassword, String privateKeyAlias, boolean forceSignRedirectBindingAuthnRequest, boolean wantsAssertionsSigned) {
        this.keystorePath = Util.fixEmptyAndTrim((String)keystorePath);
        if (keystorePassword != null && StringUtils.isNotEmpty((String)keystorePassword.getPlainText())) {
            this.keystorePasswordSecret = keystorePassword;
        }
        if (privateKeyPassword != null && StringUtils.isNotEmpty((String)privateKeyPassword.getPlainText())) {
            this.privateKeyPasswordSecret = privateKeyPassword;
        }
        this.privateKeyAlias = Util.fixEmptyAndTrim((String)privateKeyAlias);
        this.forceSignRedirectBindingAuthnRequest = forceSignRedirectBindingAuthnRequest;
        this.wantsAssertionsSigned = wantsAssertionsSigned;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    @CheckForNull
    public Secret getKeystorePassword() {
        return this.keystorePasswordSecret;
    }

    @CheckForNull
    public String getKeystorePasswordPlainText() {
        return this.keystorePasswordSecret != null ? Util.fixEmptyAndTrim((String)this.keystorePasswordSecret.getPlainText()) : null;
    }

    @CheckForNull
    public Secret getPrivateKeyPassword() {
        return this.privateKeyPasswordSecret;
    }

    @CheckForNull
    public String getPrivateKeyPasswordPlainText() {
        return this.privateKeyPasswordSecret != null ? Util.fixEmptyAndTrim((String)this.privateKeyPasswordSecret.getPlainText()) : null;
    }

    public String getPrivateKeyAlias() {
        return this.privateKeyAlias;
    }

    public boolean isForceSignRedirectBindingAuthnRequest() {
        return this.forceSignRedirectBindingAuthnRequest;
    }

    public boolean isWantsAssertionsSigned() {
        return this.wantsAssertionsSigned;
    }

    public void setWantsAssertionsSigned(boolean wantsAssertionsSigned) {
        this.wantsAssertionsSigned = wantsAssertionsSigned;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SamlEncryptionData{");
        sb.append("keystorePath='").append(StringUtils.defaultIfBlank((String)this.keystorePath, (String)"none")).append('\'');
        sb.append(", keystorePassword is NOT empty='").append(this.getKeystorePasswordPlainText() != null).append('\'');
        sb.append(", privateKeyPassword is NOT empty='").append(this.getPrivateKeyPasswordPlainText() != null).append('\'');
        sb.append(", privateKeyAlias is NOT empty='").append(StringUtils.isNotEmpty((String)this.privateKeyAlias)).append('\'');
        sb.append(", forceSignRedirectBindingAuthnRequest = ").append(this.forceSignRedirectBindingAuthnRequest);
        sb.append(", wantsAssertionsSigned = ").append(this.wantsAssertionsSigned);
        sb.append('}');
        return sb.toString();
    }

    private Object readResolve() {
        if (this.keystorePassword != null) {
            this.keystorePasswordSecret = Secret.fromString((String)this.keystorePassword);
            this.keystorePassword = null;
        }
        if (this.privateKeyPassword != null) {
            this.privateKeyPasswordSecret = Secret.fromString((String)this.privateKeyPassword);
            this.privateKeyPassword = null;
        }
        return this;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SamlEncryptionData> {
        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends SamlEncryptionData> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return "Encryption Configuration";
        }

        public FormValidation doCheckKeystorePath(@QueryParameter String keystorePath) {
            return SamlFormValidation.checkStringAttributeFormat(keystorePath, "Keystore is not set", true);
        }

        public FormValidation doCheckPrivateKeyAlias(@QueryParameter String privateKeyAlias) {
            return SamlFormValidation.checkStringAttributeFormat(privateKeyAlias, "Key alias is not set", true);
        }

        public FormValidation doCheckKeystorePassword(@QueryParameter String keystorePassword) {
            return SamlFormValidation.checkStringAttributeFormat(keystorePassword, "Keystore password is not set", true);
        }

        public FormValidation doCheckPrivateKeyPassword(@QueryParameter String privateKeyPassword) {
            return SamlFormValidation.checkStringAttributeFormat(privateKeyPassword, "Key password is not set", true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public FormValidation doTestKeyStore(@QueryParameter(value="keystorePath") String keystorePath, @QueryParameter(value="keystorePassword") Secret keystorePassword, @QueryParameter(value="privateKeyPassword") Secret privateKeyPassword, @QueryParameter(value="privateKeyAlias") String privateKeyAlias) {
            if (StringUtils.isBlank((String)keystorePath)) {
                return FormValidation.warning((String)"There is not keyStore to validate");
            }
            try (FileInputStream in = new FileInputStream(keystorePath);){
                String currentAlias;
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(in, keystorePassword.getPlainText().toCharArray());
                KeyStore.PasswordProtection keyPassword = new KeyStore.PasswordProtection(null);
                if (StringUtils.isNotBlank((String)privateKeyPassword.getPlainText())) {
                    keyPassword = new KeyStore.PasswordProtection(privateKeyPassword.getPlainText().toCharArray());
                }
                Enumeration<String> aliases = ks.aliases();
                do {
                    if (!aliases.hasMoreElements()) return FormValidation.error((String)"Not key found");
                    currentAlias = aliases.nextElement();
                } while (!StringUtils.isBlank((String)privateKeyAlias) && !currentAlias.equalsIgnoreCase(privateKeyAlias));
                ks.getEntry(currentAlias, keyPassword);
                FormValidation formValidation = FormValidation.ok((String)"Success");
                return formValidation;
            }
            catch (IOException e) {
                return FormValidation.error((Throwable)e, (String)"It is not possible to read the keystore file.");
            }
            catch (CertificateException e) {
                return FormValidation.error((Throwable)e, (String)"Any of the certificates in the keystore could not be loaded");
            }
            catch (NoSuchAlgorithmException e) {
                return FormValidation.error((Throwable)e, (String)"the algorithm used to check the integrity of the keystore cannot be found");
            }
            catch (KeyStoreException e) {
                return FormValidation.error((Throwable)e, (String)"No Provider supports a KeyStoreSpi implementation for the specified type.");
            }
            catch (UnrecoverableKeyException e) {
                return FormValidation.error((Throwable)e, (String)"The entry is a PrivateKeyEntry or SecretKeyEntry and the specified protParam does not contain the information needed to recover the key (e.g. wrong password)");
            }
            catch (UnrecoverableEntryException e) {
                return FormValidation.error((Throwable)e, (String)"The specified protParam were insufficient or invalid");
            }
        }
    }
}

