/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.util.FormValidation;
import java.io.IOException;
import java.io.InputStream;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.saml.OpenSAMLWrapper;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.pac4j.saml.util.Configuration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SamlValidateIdPMetadata
extends OpenSAMLWrapper<FormValidation> {
    private final String idpMetadata;

    public SamlValidateIdPMetadata(String idpMetadata) {
        this.idpMetadata = idpMetadata;
    }

    @Override
    protected FormValidation process() {
        try (InputStream in = IOUtils.toInputStream((String)this.idpMetadata, (String)"UTF-8");){
            Document inCommonMDDoc = Configuration.getParserPool().parse(in);
            Element metadataRoot = inCommonMDDoc.getDocumentElement();
            DOMMetadataResolver idpMetadataProvider = new DOMMetadataResolver(metadataRoot);
            idpMetadataProvider.setParserPool(Configuration.getParserPool());
            idpMetadataProvider.setFailFastInitialization(true);
            idpMetadataProvider.setRequireValidMetadata(true);
            idpMetadataProvider.setId(idpMetadataProvider.getClass().getCanonicalName());
            idpMetadataProvider.initialize();
        }
        catch (IOException e) {
            return FormValidation.error((String)"The IdP Metadata not valid.", (Object[])new Object[]{e});
        }
        catch (XMLParserException e) {
            return FormValidation.error((String)"The IdP Metadata not valid XML.", (Object[])new Object[]{e});
        }
        catch (ComponentInitializationException e) {
            return FormValidation.error((String)"The IdP Metadata not valid content.", (Object[])new Object[]{e});
        }
        return FormValidation.ok((String)"Success");
    }
}

