/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.Extension;
import hudson.security.csrf.CrumbExclusion;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Extension
public class SamlCrumbExclusion
extends CrumbExclusion {
    private static final Logger LOG = Logger.getLogger(SamlCrumbExclusion.class.getName());

    public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String pathInfo = request.getPathInfo();
        if (SamlCrumbExclusion.shouldExclude(pathInfo)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    private static boolean shouldExclude(String pathInfo) {
        if (pathInfo == null) {
            LOG.fine("SamlCrumbExclusion.shouldExclude empty");
            return false;
        }
        if (pathInfo.indexOf("securityRealm/finishLogin") == 1) {
            LOG.fine("SamlCrumbExclusion.shouldExclude excluding '" + pathInfo + "'");
            return true;
        }
        LOG.finer("SamlCrumbExclusion.shouldExclude keeping '" + pathInfo + "'");
        return false;
    }
}

