/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jenkinsci.plugins.saml.BundleKeyStore;
import org.jenkinsci.plugins.saml.SamlFileResource;
import org.jenkinsci.plugins.saml.SamlPluginConfig;
import org.jenkinsci.plugins.saml.SamlSecurityRealm;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.io.Resource;
import org.pac4j.core.io.WritableResource;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.client.SAML2ClientConfiguration;

public abstract class OpenSAMLWrapper<T> {
    private static final Logger LOG = Logger.getLogger(OpenSAMLWrapper.class.getName());
    private static final BundleKeyStore KS = new BundleKeyStore();
    protected SamlPluginConfig samlPluginConfig;
    protected StaplerRequest request;
    protected StaplerResponse response;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        T ret = null;
        try {
            LOG.finest("adapt TCCL");
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            thread.setContextClassLoader(InitializationService.class.getClassLoader());
            try {
                InitializationService.initialize();
                ret = this.process();
            }
            finally {
                LOG.finest("reset TCCL");
                thread.setContextClassLoader(loader);
            }
        }
        catch (InitializationException e) {
            LOG.log(Level.SEVERE, "Could not initialize opensaml service.", e);
            throw new IllegalStateException(e);
        }
        return ret;
    }

    protected abstract T process();

    protected WebContext createWebContext() {
        return new J2EContext((HttpServletRequest)this.request, (HttpServletResponse)this.response);
    }

    protected SAML2Client createSAML2Client() {
        SAML2ClientConfiguration config = new SAML2ClientConfiguration();
        config.setIdentityProviderMetadataResource((Resource)new SamlFileResource(SamlSecurityRealm.getIDPMetadataFilePath()));
        config.setDestinationBindingType(this.samlPluginConfig.getBinding());
        if (this.samlPluginConfig.getEncryptionData() != null) {
            config.setWantsAssertionsSigned(true);
            config.setKeystorePath(this.samlPluginConfig.getEncryptionData().getKeystorePath());
            config.setKeystorePassword(this.samlPluginConfig.getEncryptionData().getKeystorePasswordPlainText());
            config.setPrivateKeyPassword(this.samlPluginConfig.getEncryptionData().getPrivateKeyPasswordPlainText());
            config.setKeystoreAlias(this.samlPluginConfig.getEncryptionData().getPrivateKeyAlias());
            config.setForceSignRedirectBindingAuthnRequest(this.samlPluginConfig.getEncryptionData().isForceSignRedirectBindingAuthnRequest());
        } else {
            if (!KS.isValid()) {
                KS.init();
            }
            if (KS.isUsingDemoKeyStore()) {
                LOG.warning("Using bundled keystore : " + KS.getKeystorePath());
            }
            config.setKeystorePath(KS.getKeystorePath());
            config.setKeystorePassword(KS.getKsPassword());
            config.setPrivateKeyPassword(KS.getKsPkPassword());
            config.setKeystoreAlias(KS.getKsPkAlias());
            config.setForceSignRedirectBindingAuthnRequest(false);
        }
        config.setMaximumAuthenticationLifetime(this.samlPluginConfig.getMaximumAuthenticationLifetime().intValue());
        if (this.samlPluginConfig.getAdvancedConfiguration() != null) {
            config.setForceAuth(this.samlPluginConfig.getForceAuthn().booleanValue());
            if (this.samlPluginConfig.getSpEntityId() != null) {
                config.setServiceProviderEntityId(this.samlPluginConfig.getSpEntityId());
            }
            if (this.samlPluginConfig.getAuthnContextClassRef() != null) {
                config.setAuthnContextClassRef(this.samlPluginConfig.getAuthnContextClassRef());
                config.setComparisonType("exact");
            }
        }
        config.setForceServiceProviderMetadataGeneration(true);
        config.setServiceProviderMetadataResource((WritableResource)new SamlFileResource(SamlSecurityRealm.getSPMetadataFilePath()));
        SAML2Client saml2Client = new SAML2Client(config);
        saml2Client.setCallbackUrl(this.samlPluginConfig.getConsumerServiceUrl());
        saml2Client.init(this.createWebContext());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(saml2Client.getServiceProviderMetadataResolver().getMetadata());
        }
        return saml2Client;
    }
}

