/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.saml.SamlSecurityRealm;
import org.jenkinsci.plugins.saml.SamlValidateIdPMetadata;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class IdpMetadataConfiguration
extends AbstractDescribableImpl<IdpMetadataConfiguration> {
    private static final Logger LOG = Logger.getLogger(IdpMetadataConfiguration.class.getName());
    private String xml;
    private String url;
    private Long period;

    @DataBoundConstructor
    public IdpMetadataConfiguration(String xml, String url, Long period) {
        this.xml = xml;
        this.url = url;
        this.period = StringUtils.isBlank((String)url) || period == null ? Long.valueOf(0L) : period;
    }

    public IdpMetadataConfiguration(@Nonnull String xml) {
        this.xml = xml;
        this.period = 0L;
    }

    public IdpMetadataConfiguration(@Nonnull String url, @Nonnull Long period) {
        this.url = url;
        this.period = period;
    }

    public String getXml() {
        return this.xml;
    }

    public String getUrl() {
        return this.url;
    }

    public Long getPeriod() {
        return this.period;
    }

    public String getIdpMetadata() throws IOException {
        return FileUtils.readFileToString((File)new File(SamlSecurityRealm.getIDPMetadataFilePath()));
    }

    public void createIdPMetadataFile() throws IOException {
        try {
            if (StringUtils.isNotBlank((String)this.xml)) {
                FileUtils.writeStringToFile((File)new File(SamlSecurityRealm.getIDPMetadataFilePath()), (String)this.xml);
            } else {
                this.updateIdPMetadata();
            }
        }
        catch (IOException e) {
            throw new IOException("Can not write IdP metadata file in JENKINS_HOME", e);
        }
    }

    public void updateIdPMetadata() throws IOException {
        block15: {
            try {
                URLConnection urlConnection = new URL(this.url).openConnection();
                try (InputStream in = urlConnection.getInputStream();){
                    TransformerFactory tf = TransformerFactory.newInstance();
                    Transformer transformer = tf.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "no");
                    transformer.setOutputProperty("indent", "yes");
                    StringWriter writer = new StringWriter();
                    transformer.transform(new StreamSource(in), new StreamResult(writer));
                    String xml = writer.toString();
                    FormValidation validation = (FormValidation)new SamlValidateIdPMetadata(xml).get();
                    if (FormValidation.Kind.OK == validation.kind) {
                        FileUtils.writeStringToFile((File)new File(SamlSecurityRealm.getIDPMetadataFilePath()), (String)xml);
                        break block15;
                    }
                    throw new IllegalArgumentException(validation.getMessage());
                }
            }
            catch (IOException | TransformerException e) {
                throw new IOException("Was not possible to update the IdP Metadata from the URL " + this.url, e);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IdpMetadataConfiguration{");
        sb.append("xml='").append(this.xml).append('\'');
        sb.append(", url='").append(this.url).append('\'');
        sb.append(", period=").append(this.period);
        sb.append('}');
        return sb.toString();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<IdpMetadataConfiguration> {
        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends IdpMetadataConfiguration> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return "";
        }

        public FormValidation doTestIdpMetadata(@QueryParameter(value="xml") String xml) {
            if (StringUtils.isBlank((String)xml)) {
                return FormValidation.error((String)"The IdP Metadata can not be empty.");
            }
            return (FormValidation)new SamlValidateIdPMetadata(xml).get();
        }

        public FormValidation doCheckPeriod(@QueryParameter(value="period") String period) {
            if (StringUtils.isEmpty((String)period)) {
                return FormValidation.error((String)"The field should be a number greater than 0 and lower than 2147483647.");
            }
            long i = 0L;
            try {
                i = Long.parseLong(period);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"The field should be a number greater than 0 and lower than 2147483647.", (Object[])new Object[]{e});
            }
            if (i < 0L) {
                return FormValidation.error((String)"The field should be a number greater than 0 and lower than 2147483647.");
            }
            if (i > Integer.MAX_VALUE) {
                return FormValidation.error((String)"The field should be a number greater than 0 and lower than 2147483647.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckXml(@QueryParameter(value="xml") String xml, @QueryParameter(value="url") String url) {
            if (StringUtils.isBlank((String)xml) && StringUtils.isBlank((String)url)) {
                return FormValidation.error((String)"The IdP Metadata can not be empty.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUrl(@QueryParameter(value="url") String url) {
            if (StringUtils.isEmpty((String)url)) {
                return FormValidation.ok();
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"The url is malformed.", (Object[])new Object[]{e});
            }
            return FormValidation.ok();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public FormValidation doTestIdpMetadataURL(@QueryParameter(value="url") String url) {
            URLConnection urlConnection = null;
            try {
                urlConnection = new URL(url).openConnection();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                return FormValidation.error((String)("Was not possible to get the Metadata from the URL" + url));
            }
            try (InputStream in = urlConnection.getInputStream();){
                String xml = IOUtils.toString((InputStream)in, (String)StringUtils.defaultIfEmpty((String)urlConnection.getContentEncoding(), (String)"UTF-8"));
                FormValidation formValidation = (FormValidation)new SamlValidateIdPMetadata(xml).get();
                return formValidation;
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"The url is malformed.");
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                return FormValidation.error((String)("Was not possible to get the Metadata from the URL" + url));
            }
        }
    }
}

