/*
 * Decompiled with CFR 0.152.
 */
package com.waytta.clientinterface;

import com.waytta.Utils;
import com.waytta.clientinterface.BasicClient;
import hudson.Extension;
import hudson.util.FormValidation;
import java.io.IOException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class LocalBatchClient
extends BasicClient {
    private static final long serialVersionUID = 1L;
    private String function;
    private String arguments;
    private String batchSize = "100%";
    private String target;
    private String targettype;
    private transient String targetType;
    public static final BasicClient.BasicClientDescriptor DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public LocalBatchClient(String function, String arguments, String batchSize, String target, String targettype) {
        this.function = function;
        this.arguments = arguments;
        this.batchSize = batchSize;
        this.target = target;
        this.targettype = targettype;
    }

    @Override
    public String getFunction() {
        return this.function;
    }

    @Override
    public String getArguments() {
        return this.arguments;
    }

    @Override
    public String getBatchSize() {
        return this.batchSize;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public String getTargettype() {
        return this.targettype;
    }

    protected Object readResolve() throws IOException {
        if (this.targetType != null) {
            this.targettype = this.targetType;
        }
        return this;
    }

    @Symbol(value={"batch"})
    @Extension
    public static final class DescriptorImpl
    extends BasicClient.BasicClientDescriptor {
        public DescriptorImpl() {
            super(LocalBatchClient.class);
        }

        @Override
        public String getDisplayName() {
            return "local_batch";
        }

        public FormValidation doCheckFunction(@QueryParameter String value) {
            return Utils.validateFormStringField(value, "Please specify a salt function", "Isn't it too short?");
        }

        public FormValidation doCheckBatchSize(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify batch size");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTarget(@QueryParameter String value) {
            return Utils.validateFormStringField(value, "Please specify a salt target", "Isn't it too short?");
        }
    }
}

