/*
 * Decompiled with CFR 0.152.
 */
package com.waytta;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.waytta.HttpCallable;
import com.waytta.ServerToken;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;

public class Utils {
    public static ServerToken getToken(Launcher launcher, String servername, JSONObject auth) throws InterruptedException, IOException {
        String token = "";
        String server = "";
        JSONObject httpResponse = (JSONObject)JSONSerializer.toJSON((Object)launcher.getChannel().call((Callable)new HttpCallable(servername + "/login", auth, null)));
        server = httpResponse.getString("server");
        JSONArray returnArray = httpResponse.getJSONArray("return");
        for (Object o : returnArray) {
            JSONObject line = (JSONObject)o;
            token = line.getString("token");
        }
        return new ServerToken(token, server);
    }

    public static String paramorize(Run<?, ?> build, TaskListener listener, String paramer) throws IOException, InterruptedException {
        Pattern pattern = Pattern.compile("\\{\\{\\w+\\}\\}");
        Matcher matcher = pattern.matcher(paramer);
        while (matcher.find()) {
            EnvVars envVars = build.getEnvironment(listener);
            String replacementVar = matcher.group().substring(2);
            if (envVars.get((Object)(replacementVar = replacementVar.substring(0, replacementVar.length() - 2))) == null) {
                listener.fatalError("Could not find environment variable");
            }
            replacementVar = envVars.get(replacementVar, "");
            paramer = paramer.replace(matcher.group(), replacementVar);
        }
        return paramer;
    }

    public static boolean validateFunctionCall(JSONArray returnArray) {
        boolean result = true;
        JSONArray successHook = JSONArray.fromObject((Object)"[{\"Success\": True}]");
        if (returnArray.equals((Object)successHook)) {
            return true;
        }
        try {
            if (returnArray.get(0).toString().contains("TypeError")) {
                return false;
            }
            if (returnArray.getJSONObject(0).has("Error")) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (returnArray.getJSONArray(0).isArray()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Object o : returnArray) {
            JSONObject minionData;
            if (o instanceof Boolean) {
                result = (Boolean)o;
                continue;
            }
            if (o instanceof String) {
                result = false;
                continue;
            }
            JSONObject possibleMinion = JSONObject.fromObject(o);
            for (Object name : possibleMinion.names()) {
                Object field = possibleMinion.get(name.toString());
                Pattern notFoundPattern = Pattern.compile(".*/bin/sh: 1: \\w+: not found.*");
                Matcher matcher = notFoundPattern.matcher(field.toString());
                if (matcher.matches()) {
                    return false;
                }
                Pattern renderingFailed = Pattern.compile(".*Rendering SLS '[\\w:.-]*' failed.*");
                matcher = renderingFailed.matcher(field.toString());
                if (matcher.matches()) {
                    return false;
                }
                if (field.toString().contains("ERROR: Specified")) {
                    return false;
                }
                if (field.toString().contains(" is not available.")) {
                    return false;
                }
                if (field.toString().contains("The minion function caused an exception")) {
                    return false;
                }
                if (!field.toString().contains("No matching sls found for ")) continue;
                return false;
            }
            if (possibleMinion.has("data") && (minionData = possibleMinion.optJSONObject("data")) != null) {
                for (Object name : minionData.names()) {
                    Object field = minionData.get(name.toString());
                    if (!(field instanceof JSONArray) || (result = false)) continue;
                    return result;
                }
            }
            if (result = Utils.validateInnerJsonObject((JSONObject)o)) continue;
            break;
        }
        return result;
    }

    private static boolean validateInnerJsonObject(JSONObject minion) {
        String RETCODE_FIELD_NAME = "retcode";
        boolean result = true;
        for (Object name : minion.names()) {
            Object field = minion.get(name.toString());
            if (!(field instanceof JSONObject)) continue;
            JSONObject jsonObject = (JSONObject)field;
            if (jsonObject.has("retcode")) {
                boolean bl = result = jsonObject.getInt("retcode") == 0;
                if (!result) break;
            }
            if ((!jsonObject.has("result") || !jsonObject.get("result").equals("null") && (result = jsonObject.getBoolean("result"))) && (result = Utils.validateInnerJsonObject(jsonObject))) continue;
            break;
        }
        return result;
    }

    public static FormValidation validateFormStringField(String value, String lackOfFieldMessage, String fieldToShortMessage) {
        if (value.length() == 0) {
            return FormValidation.error((String)lackOfFieldMessage);
        }
        if (value.equals("*")) {
            return FormValidation.ok();
        }
        if (value.length() < 3) {
            return FormValidation.warning((String)fieldToShortMessage);
        }
        return FormValidation.ok();
    }

    public static FormValidation validatePillar(String value) {
        if (value.length() > 0) {
            Pattern pattern = Pattern.compile("\\{\\{\\w+\\}\\}");
            Matcher matcher = pattern.matcher(value);
            if (matcher.matches()) {
                return FormValidation.ok();
            }
            try {
                JSONSerializer.toJSON((Object)value);
                return FormValidation.ok();
            }
            catch (JSONException e) {
                return FormValidation.error((String)"Requires data in JSON format");
            }
        }
        return FormValidation.ok();
    }

    public static JSONObject createAuthArray(StandardUsernamePasswordCredentials credential, String authtype) {
        JSONObject auth = new JSONObject();
        auth.put("username", (Object)credential.getUsername());
        auth.put("password", (Object)credential.getPassword().getPlainText());
        auth.put("eauth", (Object)authtype);
        return auth;
    }

    public static void writeFile(String message, FilePath workspace) throws IOException, InterruptedException {
        String SALTFILE = "saltOutput.json";
        FilePath outputFile = new FilePath(workspace, "saltOutput.json");
        outputFile.write(message, "UTF-8");
    }
}

