/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3.callable;

import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.transfer.Upload;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.plugins.s3.Destination;
import hudson.plugins.s3.MD5;
import hudson.plugins.s3.Uploads;
import hudson.plugins.s3.callable.MasterSlaveCallable;
import hudson.plugins.s3.callable.S3BaseUploadCallable;
import hudson.util.Secret;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public final class S3GzipCallable
extends S3BaseUploadCallable
implements MasterSlaveCallable<String> {
    public S3GzipCallable(String accessKey, Secret secretKey, boolean useRole, Destination dest, Map<String, String> userMetadata, String storageClass, String selregion, boolean useServerSideEncryption, ProxyConfiguration proxy) {
        super(accessKey, secretKey, useRole, dest, userMetadata, storageClass, selregion, useServerSideEncryption, proxy);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private File gzipFile(FilePath file) throws IOException, InterruptedException {
        File localFile = File.createTempFile("s3plugin", ".bin");
        try (InputStream inputStream = file.read();
             FileOutputStream outputStream = new FileOutputStream(localFile);
             GZIPOutputStream gzipStream = new GZIPOutputStream((OutputStream)outputStream, true);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)gzipStream);
            ((OutputStream)gzipStream).flush();
        }
        catch (RuntimeException ex) {
            localFile.delete();
            throw ex;
        }
        return localFile;
    }

    /*
     * Loose catch block
     */
    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public String invoke(FilePath file) throws IOException, InterruptedException {
        File localFile = this.gzipFile(file);
        Upload upload = null;
        try {
            try (FileInputStream gzippedStream = new FileInputStream(localFile);){
                ObjectMetadata metadata = this.buildMetadata(file);
                metadata.setContentEncoding("gzip");
                metadata.setContentLength(localFile.length());
                upload = Uploads.getInstance().startUploading(this.getTransferManager(), file, gzippedStream, this.getDest().bucketName, this.getDest().objectName, metadata);
                String md5 = MD5.generateFromFile(localFile);
                upload.addProgressListener((ProgressListener)new CleanupHook(localFile));
                String string = md5;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (upload == null || upload.isDone()) {
                localFile.delete();
            }
        }
    }

    private static class CleanupHook
    implements ProgressListener {
        private final File localFile;

        CleanupHook(File localFile) {
            this.localFile = localFile;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE", "SF_SWITCH_NO_DEFAULT"})
        public void progressChanged(ProgressEvent event) {
            switch (event.getEventType()) {
                case TRANSFER_CANCELED_EVENT: 
                case TRANSFER_COMPLETED_EVENT: 
                case TRANSFER_FAILED_EVENT: {
                    this.localFile.delete();
                }
            }
        }
    }
}

